/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonEntry
extends Button {
    private static final int ANIM_TIME = 5;
    private final GuiBook parent;
    private final BookEntry entry;
    private float timeHovered;

    public GuiButtonEntry(GuiBook parent, int x, int y, BookEntry entry, Button.IPressable onPress) {
        super(x, y, 116, 10, (ITextComponent)entry.getName(), onPress);
        this.parent = parent;
        this.entry = entry;
    }

    public void func_230431_b_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230693_o_) {
            IFormattableTextComponent name;
            this.timeHovered = this.func_230449_g_() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.func_230449_g_() ? partialTicks : -partialTicks)));
            float widthFract = time / 5.0f;
            boolean locked = this.entry.isLocked();
            ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(this.field_230690_l_ * 2), (int)(this.field_230691_m_ * 2), (int)((this.field_230690_l_ + (int)((float)this.field_230688_j_ * widthFract)) * 2), (int)((this.field_230691_m_ + this.field_230689_k_) * 2), (int)0x22000000);
            RenderSystem.enableBlend();
            if (locked) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(ms, this.parent.book, this.field_230690_l_ * 2 + 2, this.field_230691_m_ * 2 + 2);
            } else {
                this.entry.getIcon().render(ms, this.field_230690_l_ * 2 + 2, this.field_230691_m_ * 2 + 2);
            }
            ms.func_227862_a_(2.0f, 2.0f, 2.0f);
            if (locked) {
                name = new TranslationTextComponent("patchouli.gui.lexicon.locked");
            } else {
                name = this.entry.getName();
                if (this.entry.isPriority()) {
                    name = name.func_240699_a_(TextFormatting.ITALIC);
                }
            }
            name = name.func_240703_c_(this.entry.getBook().getFontStyle());
            Minecraft.func_71410_x().field_71466_p.func_238422_b_(ms, name.func_241878_f(), (float)(this.field_230690_l_ + 12), (float)this.field_230691_m_, this.getColor());
            if (!this.entry.isLocked()) {
                GuiBook.drawMarking(ms, this.parent.book, this.field_230690_l_ + this.field_230688_j_ - 5, this.field_230691_m_ + 1, this.entry.hashCode(), this.entry.getReadState());
            }
        }
    }

    private int getColor() {
        if (this.entry.isSecret()) {
            return 0xAA000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        if (this.entry.isLocked()) {
            return 0x77000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        return this.entry.getEntryColor();
    }

    public void func_230988_a_(SoundHandler soundHandlerIn) {
        if (this.entry != null && !this.entry.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }
}

