/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.book.Book;

public class BookTextRenderer {
    private final Book book;
    private final GuiBook gui;
    private final String text;
    private final int x;
    private final int y;
    private final int width;
    private final int lineHeight;
    private final Style baseStyle;
    private List<Word> words;

    public BookTextRenderer(GuiBook gui, String text, int x, int y) {
        this(gui, text, x, y, 116, 9, gui.book.textColor);
    }

    public BookTextRenderer(GuiBook gui, String text, int x, int y, int width, int lineHeight, int baseColor) {
        this.book = gui.book;
        this.gui = gui;
        this.text = this.book.i18n ? I18n.func_135052_a((String)text, (Object[])new Object[0]) : text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.lineHeight = lineHeight;
        this.baseStyle = this.book.getFontStyle().func_240718_a_(Color.func_240743_a_((int)baseColor));
        this.build();
    }

    private void build() {
        BookTextParser parser = new BookTextParser(this.gui, this.book, this.x, this.y, this.width, this.lineHeight, this.baseStyle);
        this.words = parser.parse(this.text);
    }

    public void render(MatrixStack ms, int mouseX, int mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        Style style = this.book.getFontStyle();
        this.words.forEach(word -> word.render(ms, font, style, mouseX, mouseY));
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        for (Word word : this.words) {
            if (!word.click(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }
}

