/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen;

import appeng.mixins.structure.BiomeAccessor;
import appeng.mixins.structure.GenerationSettingsAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;

public final class BiomeModifier {
    private final BiomeAccessor biomeAccessor;
    private final GenerationSettingsAccessor generationSettingsAccessor;

    public BiomeModifier(Biome biome) {
        this.biomeAccessor = (BiomeAccessor)biome;
        this.generationSettingsAccessor = (GenerationSettingsAccessor)biome.func_242440_e();
    }

    public void addFeature(GenerationStage.Decoration step, ConfiguredFeature<?, ?> feature) {
        int stepIndex = step.ordinal();
        ArrayList featuresByStep = new ArrayList(this.generationSettingsAccessor.getFeatures());
        while (featuresByStep.size() <= stepIndex) {
            featuresByStep.add(Lists.newArrayList());
        }
        ArrayList<Supplier<ConfiguredFeature>> features = new ArrayList<Supplier<ConfiguredFeature>>((Collection)featuresByStep.get(stepIndex));
        features.add(() -> feature);
        featuresByStep.set(stepIndex, features);
        this.generationSettingsAccessor.setFeatures(featuresByStep);
    }

    public void addStructureFeature(StructureFeature<?, ?> structure) {
        ArrayList features = new ArrayList(this.generationSettingsAccessor.getStructureFeatures());
        features.add(() -> structure);
        this.generationSettingsAccessor.setStructureFeatures(features);
        Map<Integer, List<Structure<?>>> structuresByStage = this.biomeAccessor.getField_242421_g();
        int step = structure.field_236268_b_.func_236396_f_().ordinal();
        if (!structuresByStage.containsKey(step)) {
            structuresByStage.put(step, new ArrayList());
        }
        structuresByStage.get(step).add(structure.field_236268_b_);
    }
}

