/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.AESharedItemStack;
import appeng.util.item.MeaningfulItemIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

abstract class AbstractItemList
implements IItemList<IAEItemStack> {
    AbstractItemList() {
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.add(option);
            return;
        }
        IAEItemStack opt = option.copy();
        this.putItemRecord(opt);
    }

    @Override
    public IAEItemStack findPrecise(IAEItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return this.getRecords().get(((AEItemStack)itemStack).getSharedStack());
    }

    @Override
    public Collection<IAEItemStack> findFuzzy(IAEItemStack filter, FuzzyMode fuzzy) {
        if (filter == null) {
            return Collections.emptyList();
        }
        return this.getRecords().values();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public void addStorage(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEItemStack opt = option.copy();
        this.putItemRecord(opt);
    }

    @Override
    public void addCrafting(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEItemStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.putItemRecord(opt);
    }

    @Override
    public void addRequestable(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEItemStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(option.getCountRequestable());
        this.putItemRecord(opt);
    }

    @Override
    public IAEItemStack getFirstItem() {
        Iterator<IAEItemStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEItemStack stackType = iterator.next();
            return stackType;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (IAEItemStack entry : this.getRecords().values()) {
            if (!entry.isMeaningful()) continue;
            ++size;
        }
        return size;
    }

    @Override
    public Iterator<IAEItemStack> iterator() {
        return new MeaningfulItemIterator<IAEItemStack>(this.getRecords().values());
    }

    @Override
    public void resetStatus() {
        for (IAEItemStack i : this) {
            i.reset();
        }
    }

    abstract Map<AESharedItemStack, IAEItemStack> getRecords();

    private IAEItemStack putItemRecord(IAEItemStack itemStack) {
        return this.getRecords().put(((AEItemStack)itemStack).getSharedStack(), itemStack);
    }
}

