/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.SortOrder;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.stats.AeStats;
import appeng.fluids.util.AEFluidStack;
import appeng.hooks.TickHandler;
import appeng.integration.abstraction.JEIFacade;
import appeng.me.GridAccessException;
import appeng.me.GridNode;
import appeng.me.helpers.AENetworkProxy;
import appeng.util.BlockUpdate;
import appeng.util.LookDirection;
import appeng.util.helpers.ItemComparisonHelper;
import appeng.util.helpers.P2PHelper;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Platform {
    public static final int DEF_OFFSET = 16;
    private static final boolean CLIENT_INSTALL = FMLEnvironment.dist.isClient();
    private static final Random RANDOM_GENERATOR = new Random();
    private static final WeakHashMap<World, PlayerEntity> FAKE_PLAYERS = new WeakHashMap();
    private static final ItemComparisonHelper ITEM_COMPARISON_HELPER = new ItemComparisonHelper();
    private static final P2PHelper P2P_HELPER = new P2PHelper();

    public static ItemComparisonHelper itemComparisons() {
        return ITEM_COMPARISON_HELPER;
    }

    public static P2PHelper p2p() {
        return P2P_HELPER;
    }

    public static Random getRandom() {
        return RANDOM_GENERATOR;
    }

    public static float getRandomFloat() {
        return RANDOM_GENERATOR.nextFloat();
    }

    public static String formatPowerLong(long n, boolean isRate) {
        double p = (double)n / 100.0;
        PowerUnits displayUnits = AEConfig.instance().getSelectedPowerUnit();
        p = PowerUnits.AE.convertTo(displayUnits, p);
        String[] preFixes = new String[]{"k", "M", "G", "T", "P", "T", "P", "E", "Z", "Y"};
        String unitName = displayUnits.name();
        String level = "";
        for (int offset = 0; p > 1000.0 && offset < preFixes.length; p /= 1000.0, ++offset) {
            level = preFixes[offset];
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(p) + ' ' + level + unitName + (isRate ? "/t" : "");
    }

    public static Direction crossProduct(Direction forward, Direction up) {
        int west_x = forward.func_96559_d() * up.func_82599_e() - forward.func_82599_e() * up.func_96559_d();
        int west_y = forward.func_82599_e() * up.func_82601_c() - forward.func_82601_c() * up.func_82599_e();
        int west_z = forward.func_82601_c() * up.func_96559_d() - forward.func_96559_d() * up.func_82601_c();
        switch (west_x + west_y * 2 + west_z * 3) {
            case 1: {
                return Direction.EAST;
            }
            case -1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.UP;
            }
            case -2: {
                return Direction.DOWN;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case -3: {
                return Direction.NORTH;
            }
        }
        return Direction.NORTH;
    }

    public static boolean hasClientClasses() {
        return FMLEnvironment.dist.isClient();
    }

    public static boolean isClient() {
        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER;
    }

    public static boolean isClientInstall() {
        return CLIENT_INSTALL;
    }

    public static boolean hasPermissions(DimensionalCoord dc, PlayerEntity player) {
        if (!dc.isInWorld((IWorld)player.field_70170_p)) {
            return false;
        }
        return player.field_70170_p.func_175660_a(player, dc.getPos());
    }

    public static boolean checkPermissions(PlayerEntity player, Object accessInterface, SecurityPermissions requiredPermission, boolean notifyPlayer) {
        IGrid g;
        IGridNode gn;
        if (requiredPermission != null && accessInterface instanceof IActionHost && (gn = ((IActionHost)accessInterface).getActionableNode()) != null && (g = gn.getGrid()) != null) {
            boolean requirePower = false;
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (!sg.hasPermission(player, requiredPermission)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("appliedenergistics2.permission_denied").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                return false;
            }
        }
        return true;
    }

    public static ItemStack[] getBlockDrops(World w, BlockPos pos) {
        if (!(w instanceof ServerWorld)) {
            return new ItemStack[0];
        }
        ServerWorld serverWorld = (ServerWorld)w;
        BlockState state = w.func_180495_p(pos);
        TileEntity tileEntity = w.func_175625_s(pos);
        List out = Block.func_220070_a((BlockState)state, (ServerWorld)serverWorld, (BlockPos)pos, (TileEntity)tileEntity);
        return out.toArray(new ItemStack[0]);
    }

    public static void spawnDrops(World w, BlockPos pos, List<ItemStack> drops) {
        if (Platform.isServer()) {
            for (ItemStack i : drops) {
                if (i.func_190926_b() || i.func_190916_E() <= 0) continue;
                double offset_x = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_y = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_z = (Platform.getRandomInt() % 32 - 16) / 82;
                ItemEntity ei = new ItemEntity(w, 0.5 + offset_x + (double)pos.func_177958_n(), 0.5 + offset_y + (double)pos.func_177956_o(), 0.2 + offset_z + (double)pos.func_177952_p(), i.func_77946_l());
                w.func_217376_c((Entity)ei);
            }
        }
    }

    public static boolean isServer() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
    }

    public static int getRandomInt() {
        return Math.abs(RANDOM_GENERATOR.nextInt());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<ITextComponent> getTooltip(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        if (o instanceof AEItemStack) {
            AEItemStack ais = (AEItemStack)o;
            return ais.getToolTip();
        }
        if (!(o instanceof ItemStack)) {
            return Collections.emptyList();
        }
        itemStack = (ItemStack)o;
        try {
            ITooltipFlag.TooltipFlags tooltipFlag = Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            return itemStack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)tooltipFlag);
        }
        catch (Exception errB) {
            return Collections.emptyList();
        }
    }

    public static String getModId(IAEItemStack is) {
        if (is == null) {
            return "** Null";
        }
        String n = ((AEItemStack)is).getModID();
        return n == null ? "** Null" : n;
    }

    public static String getModId(IAEFluidStack fs) {
        if (fs == null || fs.getFluidStack().isEmpty()) {
            return "** Null";
        }
        ResourceLocation n = ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fs.getFluidStack().getFluid());
        return n == null ? "** Null" : n.func_110624_b();
    }

    public static String getModName(String modId) {
        return "" + TextFormatting.BLUE + TextFormatting.ITALIC + (String)ModList.get().getModContainerById(modId).map(mc -> mc.getModInfo().getDisplayName()).orElse(null);
    }

    public static ITextComponent getItemDisplayName(Object o) {
        if (o == null) {
            return new StringTextComponent("** Null");
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        if (o instanceof AEItemStack) {
            ITextComponent n = ((AEItemStack)o).getDisplayName();
            return n == null ? new StringTextComponent("** Null") : n;
        }
        if (!(o instanceof ItemStack)) {
            return new StringTextComponent("**Invalid Object");
        }
        itemStack = (ItemStack)o;
        try {
            return itemStack.func_200301_q();
        }
        catch (Exception errA) {
            try {
                return new TranslationTextComponent(itemStack.func_77977_a());
            }
            catch (Exception errB) {
                return new StringTextComponent("** Exception");
            }
        }
    }

    public static ITextComponent getFluidDisplayName(Object o) {
        if (o == null) {
            return new StringTextComponent("** Null");
        }
        FluidStack fluidStack = null;
        if (o instanceof AEFluidStack) {
            fluidStack = ((AEFluidStack)o).getFluidStack();
        } else if (o instanceof FluidStack) {
            fluidStack = (FluidStack)o;
        } else {
            return new StringTextComponent("**Invalid Object");
        }
        ITextComponent n = fluidStack.getDisplayName();
        if (n == null) {
            n = new TranslationTextComponent(fluidStack.getTranslationKey());
        }
        return n;
    }

    public static boolean isWrench(PlayerEntity player, ItemStack eq, BlockPos pos) {
        if (!eq.func_190926_b() && eq.func_77973_b() instanceof IAEWrench) {
            IAEWrench wrench = (IAEWrench)eq.func_77973_b();
            return wrench.canWrench(eq, player, pos);
        }
        return false;
    }

    public static boolean isChargeable(ItemStack i) {
        if (i.func_190926_b()) {
            return false;
        }
        Item it = i.func_77973_b();
        if (it instanceof IAEItemPowerStorage) {
            return ((IAEItemPowerStorage)it).getPowerFlow(i) != AccessRestriction.READ;
        }
        return false;
    }

    public static PlayerEntity getPlayer(ServerWorld w) {
        Objects.requireNonNull(w);
        PlayerEntity wrp = FAKE_PLAYERS.get(w);
        if (wrp != null) {
            return wrp;
        }
        FakePlayer p = FakePlayerFactory.getMinecraft((ServerWorld)w);
        FAKE_PLAYERS.put((World)w, (PlayerEntity)p);
        return p;
    }

    @Nullable
    public static <T> T pickRandom(Collection<T> outs) {
        if (outs.isEmpty()) {
            return null;
        }
        int index = RANDOM_GENERATOR.nextInt(outs.size());
        return (T)Iterables.get(outs, (int)index, null);
    }

    public static AEPartLocation rotateAround(AEPartLocation forward, AEPartLocation axis) {
        if (axis == AEPartLocation.INTERNAL || forward == AEPartLocation.INTERNAL) {
            return forward;
        }
        switch (forward) {
            case DOWN: {
                switch (axis) {
                    case DOWN: {
                        return forward;
                    }
                    case UP: {
                        return forward;
                    }
                    case NORTH: {
                        return AEPartLocation.EAST;
                    }
                    case SOUTH: {
                        return AEPartLocation.WEST;
                    }
                    case EAST: {
                        return AEPartLocation.NORTH;
                    }
                    case WEST: {
                        return AEPartLocation.SOUTH;
                    }
                }
                break;
            }
            case UP: {
                switch (axis) {
                    case NORTH: {
                        return AEPartLocation.WEST;
                    }
                    case SOUTH: {
                        return AEPartLocation.EAST;
                    }
                    case EAST: {
                        return AEPartLocation.SOUTH;
                    }
                    case WEST: {
                        return AEPartLocation.NORTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.WEST;
                    }
                    case DOWN: {
                        return AEPartLocation.EAST;
                    }
                    case EAST: {
                        return AEPartLocation.UP;
                    }
                    case WEST: {
                        return AEPartLocation.DOWN;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.EAST;
                    }
                    case DOWN: {
                        return AEPartLocation.WEST;
                    }
                    case EAST: {
                        return AEPartLocation.DOWN;
                    }
                    case WEST: {
                        return AEPartLocation.UP;
                    }
                }
                break;
            }
            case EAST: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.NORTH;
                    }
                    case DOWN: {
                        return AEPartLocation.SOUTH;
                    }
                    case NORTH: {
                        return AEPartLocation.UP;
                    }
                    case SOUTH: {
                        return AEPartLocation.DOWN;
                    }
                }
            }
            case WEST: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.SOUTH;
                    }
                    case DOWN: {
                        return AEPartLocation.NORTH;
                    }
                    case NORTH: {
                        return AEPartLocation.DOWN;
                    }
                    case SOUTH: {
                        return AEPartLocation.UP;
                    }
                }
            }
        }
        return forward;
    }

    public static Direction rotateAround(Direction forward, Direction axis) {
        switch (forward) {
            case DOWN: {
                switch (axis) {
                    case DOWN: {
                        return forward;
                    }
                    case UP: {
                        return forward;
                    }
                    case NORTH: {
                        return Direction.EAST;
                    }
                    case SOUTH: {
                        return Direction.WEST;
                    }
                    case EAST: {
                        return Direction.NORTH;
                    }
                    case WEST: {
                        return Direction.SOUTH;
                    }
                }
                break;
            }
            case UP: {
                switch (axis) {
                    case NORTH: {
                        return Direction.WEST;
                    }
                    case SOUTH: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.SOUTH;
                    }
                    case WEST: {
                        return Direction.NORTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (axis) {
                    case UP: {
                        return Direction.WEST;
                    }
                    case DOWN: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.UP;
                    }
                    case WEST: {
                        return Direction.DOWN;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (axis) {
                    case UP: {
                        return Direction.EAST;
                    }
                    case DOWN: {
                        return Direction.WEST;
                    }
                    case EAST: {
                        return Direction.DOWN;
                    }
                    case WEST: {
                        return Direction.UP;
                    }
                }
                break;
            }
            case EAST: {
                switch (axis) {
                    case UP: {
                        return Direction.NORTH;
                    }
                    case DOWN: {
                        return Direction.SOUTH;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                }
            }
            case WEST: {
                switch (axis) {
                    case UP: {
                        return Direction.SOUTH;
                    }
                    case DOWN: {
                        return Direction.NORTH;
                    }
                    case NORTH: {
                        return Direction.DOWN;
                    }
                    case SOUTH: {
                        return Direction.UP;
                    }
                }
            }
        }
        return forward;
    }

    public static LookDirection getPlayerRay(PlayerEntity playerIn) {
        double reachDistance = playerIn.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return Platform.getPlayerRay(playerIn, reachDistance);
    }

    public static LookDirection getPlayerRay(PlayerEntity playerIn, double reachDistance) {
        double x = playerIn.field_70169_q + (playerIn.func_226277_ct_() - playerIn.field_70169_q);
        double y = playerIn.field_70167_r + (playerIn.func_226278_cu_() - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double z = playerIn.field_70166_s + (playerIn.func_226281_cx_() - playerIn.field_70166_s);
        float playerPitch = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C);
        float playerYaw = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B);
        float yawRayX = MathHelper.func_76126_a((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = MathHelper.func_76134_b((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -MathHelper.func_76134_b((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = MathHelper.func_76126_a((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        Vector3d from = new Vector3d(x, y, z);
        Vector3d to = from.func_72441_c((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return new LookDirection(from, to);
    }

    public static RayTraceResult rayTrace(PlayerEntity p, boolean hitBlocks, boolean hitEntities) {
        World w = p.func_130014_f_();
        float f = 1.0f;
        float f1 = p.field_70127_C + (p.field_70125_A - p.field_70127_C) * 1.0f;
        float f2 = p.field_70126_B + (p.field_70177_z - p.field_70126_B) * 1.0f;
        double d0 = p.field_70169_q + (p.func_226277_ct_() - p.field_70169_q) * 1.0;
        double d1 = p.field_70167_r + (p.func_226278_cu_() - p.field_70167_r) * 1.0 + 1.62 - p.func_70033_W();
        double d2 = p.field_70166_s + (p.func_226281_cx_() - p.field_70166_s) * 1.0;
        Vector3d vec3 = new Vector3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 32.0;
        Vector3d vec31 = vec3.func_72441_c((double)f7 * 32.0, (double)f6 * 32.0, (double)f8 * 32.0);
        AxisAlignedBB bb = new AxisAlignedBB(Math.min(vec3.field_72450_a, vec31.field_72450_a), Math.min(vec3.field_72448_b, vec31.field_72448_b), Math.min(vec3.field_72449_c, vec31.field_72449_c), Math.max(vec3.field_72450_a, vec31.field_72450_a), Math.max(vec3.field_72448_b, vec31.field_72448_b), Math.max(vec3.field_72449_c, vec31.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
        Entity entity = null;
        double closest = 9999999.0;
        if (hitEntities) {
            List list = w.func_72839_b((Entity)p, bb);
            for (Entity entity1 : list) {
                double nd;
                if (!entity1.func_70089_S() || entity1 == p || entity1 instanceof ItemEntity || entity1.func_184215_y((Entity)p)) continue;
                f1 = 0.3f;
                AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                Vector3d rtResult = boundingBox.func_216365_b(vec3, vec31).orElse(null);
                if (rtResult == null || !((nd = vec3.func_72436_e(rtResult)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
        }
        EntityRayTraceResult pos = null;
        Vector3d vec = null;
        if (hitBlocks) {
            vec = new Vector3d(d0, d1, d2);
            pos = w.func_217299_a(new RayTraceContext(vec3, vec31, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)p));
        }
        if (entity != null && pos != null && pos.func_216347_e().func_72436_e(vec) > closest) {
            pos = new EntityRayTraceResult(entity);
        } else if (entity != null && pos == null) {
            pos = new EntityRayTraceResult(entity);
        }
        return pos;
    }

    public static <T extends IAEStack<T>> T poweredExtraction(IEnergySource energy, IMEInventory<T> cell, T request, IActionSource src) {
        return Platform.poweredExtraction(energy, cell, request, src, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T poweredExtraction(IEnergySource energy, IMEInventory<T> cell, T request, IActionSource src, Actionable mode) {
        double energyFactor;
        double availablePower;
        long itemToExtract;
        Preconditions.checkNotNull((Object)energy);
        Preconditions.checkNotNull(cell);
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)((Object)mode));
        T possible = cell.extractItems(request.copy(), Actionable.SIMULATE, src);
        long retrieved = 0L;
        if (possible != null) {
            retrieved = possible.getStackSize();
        }
        if ((itemToExtract = Math.min((long)((availablePower = energy.extractAEPower((double)retrieved / (energyFactor = Math.max(1.0, (double)cell.getChannel().transferFactor())), Actionable.SIMULATE, PowerMultiplier.CONFIG)) * energyFactor + 0.9), retrieved)) > 0L) {
            if (mode == Actionable.MODULATE) {
                energy.extractAEPower((double)retrieved / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
                possible.setStackSize(itemToExtract);
                Object ret = cell.extractItems(possible, Actionable.MODULATE, src);
                if (ret != null) {
                    src.player().ifPresent(player -> AeStats.ItemsExtracted.addToPlayer((PlayerEntity)player, (int)ret.getStackSize()));
                }
                return ret;
            }
            return possible.setStackSize(itemToExtract);
        }
        return null;
    }

    public static <T extends IAEStack<T>> T poweredInsert(IEnergySource energy, IMEInventory<T> cell, T input, IActionSource src) {
        return Platform.poweredInsert(energy, cell, input, src, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T poweredInsert(IEnergySource energy, IMEInventory<T> cell, T input, IActionSource src, Actionable mode) {
        double energyFactor;
        double availablePower;
        long itemToAdd;
        Preconditions.checkNotNull((Object)energy);
        Preconditions.checkNotNull(cell);
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)((Object)mode));
        T overflow = cell.injectItems(input.copy(), Actionable.SIMULATE, src);
        long transferAmount = input.getStackSize();
        if (overflow != null) {
            transferAmount -= overflow.getStackSize();
        }
        if ((itemToAdd = Math.min((long)((availablePower = energy.extractAEPower((double)transferAmount / (energyFactor = Math.max(1.0, (double)cell.getChannel().transferFactor())), Actionable.SIMULATE, PowerMultiplier.CONFIG)) * energyFactor + 0.9), transferAmount)) > 0L) {
            if (mode == Actionable.MODULATE) {
                energy.extractAEPower((double)transferAmount / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (itemToAdd < input.getStackSize()) {
                    long original = input.getStackSize();
                    Object leftover = input.copy();
                    T split = input.copy();
                    leftover.decStackSize(itemToAdd);
                    split.setStackSize(itemToAdd);
                    leftover.add(cell.injectItems(split, Actionable.MODULATE, src));
                    src.player().ifPresent(player -> {
                        long diff = original - leftover.getStackSize();
                        AeStats.ItemsInserted.addToPlayer((PlayerEntity)player, (int)diff);
                    });
                    return leftover;
                }
                Object ret = cell.injectItems(input, Actionable.MODULATE, src);
                src.player().ifPresent(player -> {
                    long diff = ret == null ? input.getStackSize() : input.getStackSize() - ret.getStackSize();
                    AeStats.ItemsInserted.addToPlayer((PlayerEntity)player, (int)diff);
                });
                return ret;
            }
            T ret = input.copy().setStackSize(input.getStackSize() - itemToAdd);
            return ret != null && ret.getStackSize() > 0L ? (T)ret : null;
        }
        return input;
    }

    public static void postChanges(IStorageGrid gs, ItemStack removed, ItemStack added, IActionSource src) {
        for (IStorageChannel<IAEStack<?>> chan : Api.instance().storage().storageChannels()) {
            ICellInventoryHandler<IAEStack<?>> myInv;
            IItemList<IAEStack<?>> myChanges = chan.createList();
            if (!removed.func_190926_b() && (myInv = Api.instance().registries().cell().getCellInventory(removed, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
                for (IAEStack<?> is : myChanges) {
                    is.setStackSize(-is.getStackSize());
                }
            }
            if (!added.func_190926_b() && (myInv = Api.instance().registries().cell().getCellInventory(added, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
            }
            gs.postAlterationOfStoredItems(chan, myChanges, src);
        }
    }

    public static <T extends IAEStack<T>> void postListChanges(IItemList<T> before, IItemList<T> after, IMEMonitorHandlerReceiver<T> meMonitorPassthrough, IActionSource source) {
        ArrayList<IAEStack> changes = new ArrayList<IAEStack>();
        for (IAEStack is : before) {
            is.setStackSize(-is.getStackSize());
        }
        for (IAEStack is : after) {
            before.add(is);
        }
        for (IAEStack is : before) {
            if (is.getStackSize() == 0L) continue;
            changes.add(is);
        }
        if (!changes.isEmpty()) {
            meMonitorPassthrough.postChange(null, changes, source);
        }
    }

    public static boolean securityCheck(GridNode a, GridNode b) {
        boolean b_isSecure;
        if (a.getLastSecurityKey() == -1L && b.getLastSecurityKey() == -1L) {
            return true;
        }
        if (a.getLastSecurityKey() == b.getLastSecurityKey()) {
            return true;
        }
        boolean a_isSecure = Platform.isPowered(a.getGrid()) && a.getLastSecurityKey() != -1L;
        boolean bl = b_isSecure = Platform.isPowered(b.getGrid()) && b.getLastSecurityKey() != -1L;
        if (AEConfig.instance().isFeatureEnabled(AEFeature.LOG_SECURITY_AUDITS)) {
            String locationA = a.getGridBlock().isWorldAccessible() ? a.getGridBlock().getLocation().toString() : "notInWorld";
            String locationB = b.getGridBlock().isWorldAccessible() ? b.getGridBlock().getLocation().toString() : "notInWorld";
            AELog.info("Audit: Node A [isSecure=%b, key=%d, playerID=%d, location={%s}] vs Node B[isSecure=%b, key=%d, playerID=%d, location={%s}]", a_isSecure, a.getLastSecurityKey(), a.getPlayerID(), locationA, b_isSecure, b.getLastSecurityKey(), b.getPlayerID(), locationB);
        }
        if (a_isSecure && b_isSecure) {
            return false;
        }
        if (!a_isSecure && b_isSecure) {
            return Platform.checkPlayerPermissions(b.getGrid(), a.getPlayerID());
        }
        if (a_isSecure && !b_isSecure) {
            return Platform.checkPlayerPermissions(a.getGrid(), b.getPlayerID());
        }
        return true;
    }

    private static boolean isPowered(IGrid grid) {
        if (grid == null) {
            return false;
        }
        IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        return eg.isNetworkPowered();
    }

    private static boolean checkPlayerPermissions(IGrid grid, int playerID) {
        if (grid == null) {
            return true;
        }
        ISecurityGrid gs = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        if (gs == null) {
            return true;
        }
        if (!gs.isAvailable()) {
            return true;
        }
        return gs.hasPermission(playerID, SecurityPermissions.BUILD);
    }

    public static void configurePlayer(PlayerEntity player, AEPartLocation side, TileEntity tile) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case DOWN: {
                pitch = 90.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case INTERNAL: {
                break;
            }
            case UP: {
                pitch = 90.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
            }
        }
        player.func_70012_b((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5, yaw, pitch);
    }

    public static boolean canAccess(AENetworkProxy gridProxy, IActionSource src) {
        try {
            if (src.player().isPresent()) {
                return gridProxy.getSecurity().hasPermission(src.player().get(), SecurityPermissions.BUILD);
            }
            if (src.machine().isPresent()) {
                IActionHost te = src.machine().get();
                IGridNode n = te.getActionableNode();
                if (n == null) {
                    return false;
                }
                int playerID = n.getPlayerID();
                return gridProxy.getSecurity().hasPermission(playerID, SecurityPermissions.BUILD);
            }
            return false;
        }
        catch (GridAccessException gae) {
            return false;
        }
    }

    public static ItemStack extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, IMEMonitor<IAEItemStack> src, World w, IRecipe<CraftingInventory> r, ItemStack output, CraftingInventory ci, ItemStack providedTemplate, int slot, IItemList<IAEItemStack> items, Actionable realForFake, IPartitionList<IAEItemStack> filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            ItemStack extracted;
            IAEItemStack ae_ext;
            if (providedTemplate == null) {
                return ItemStack.field_190927_a;
            }
            AEItemStack ae_req = AEItemStack.fromItemStack(providedTemplate);
            ae_req.setStackSize(1L);
            if ((filter == null || filter.isListed(ae_req)) && (ae_ext = src.extractItems(ae_req, realForFake, mySrc)) != null && !(extracted = ae_ext.createItemStack()).func_190926_b()) {
                energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                return extracted;
            }
            boolean bl = checkFuzzy = providedTemplate.func_77942_o() || providedTemplate.func_77984_f();
            if (items != null && checkFuzzy) {
                for (IAEItemStack x : items) {
                    ItemStack sh = x.getDefinition();
                    if (!Platform.itemComparisons().isEqualItemType(providedTemplate, sh) || ItemStack.func_179545_c((ItemStack)sh, (ItemStack)output)) continue;
                    ItemStack cp = sh.func_77946_l();
                    cp.func_190920_e(1);
                    ci.func_70299_a(slot, cp);
                    if (r.func_77569_a((IInventory)ci, w) && ItemStack.func_179545_c((ItemStack)r.func_77572_b((IInventory)ci), (ItemStack)output)) {
                        IAEItemStack ex;
                        IAEItemStack ax = x.copy();
                        ax.setStackSize(1L);
                        if ((filter == null || filter.isListed(ax)) && (ex = src.extractItems(ax, realForFake, mySrc)) != null) {
                            energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                            return ex.createItemStack();
                        }
                    }
                    ci.func_70299_a(slot, providedTemplate);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getContainerItem(ItemStack stackInSlot) {
        if (stackInSlot == null) {
            return ItemStack.field_190927_a;
        }
        Item i = stackInSlot.func_77973_b();
        if (i == null || !i.hasContainerItem(stackInSlot)) {
            if (stackInSlot.func_190916_E() > 1) {
                stackInSlot.func_190920_e(stackInSlot.func_190916_E() - 1);
                return stackInSlot;
            }
            return ItemStack.field_190927_a;
        }
        ItemStack ci = i.getContainerItem(stackInSlot.func_77946_l());
        if (!ci.func_190926_b() && ci.func_77984_f() && ci.func_77952_i() == ci.func_77958_k()) {
            ci = ItemStack.field_190927_a;
        }
        return ci;
    }

    public static void notifyBlocksOfNeighbors(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            TickHandler.instance().addCallable((IWorld)world, new BlockUpdate(pos));
        }
    }

    public static boolean canRepair(AEFeature type, ItemStack a, ItemStack b) {
        if (b.func_190926_b() || a.func_190926_b()) {
            return false;
        }
        if (type == AEFeature.CERTUS_QUARTZ_TOOLS) {
            IItemDefinition certusQuartzCrystal = Api.instance().definitions().materials().certusQuartzCrystal();
            return certusQuartzCrystal.isSameAs(b);
        }
        if (type == AEFeature.NETHER_QUARTZ_TOOLS) {
            return Items.field_151128_bU == b.func_77973_b();
        }
        return false;
    }

    public static float getEyeOffset(PlayerEntity player) {
        assert (player.field_70170_p.field_72995_K) : "Valid only on client";
        return (float)(player.func_226278_cu_() + (double)player.func_70047_e() - (double)1.62f);
    }

    public static boolean isRecipePrioritized(ItemStack what) {
        IMaterials materials = Api.instance().definitions().materials();
        boolean isPurified = materials.purifiedCertusQuartzCrystal().isSameAs(what);
        isPurified |= materials.purifiedFluixCrystal().isSameAs(what);
        return isPurified |= materials.purifiedNetherQuartzCrystal().isSameAs(what);
    }

    public static boolean isSortOrderAvailable(SortOrder order) {
        return true;
    }

    public static boolean isSearchModeAvailable(SearchBoxMode mode) {
        if (mode.isRequiresJei()) {
            return JEIFacade.instance().isEnabled();
        }
        return true;
    }
}

