/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import java.util.EnumSet;

public final class EnumCycler {
    private EnumCycler() {
    }

    public static <T extends Enum<T>> T rotateEnum(T ce, boolean backwards, EnumSet<T> validOptions) {
        while (!validOptions.contains(ce = backwards ? EnumCycler.prevEnum(ce) : EnumCycler.next(ce))) {
        }
        return ce;
    }

    public static <T extends Enum<T>> T prevEnum(T ce) {
        Enum[] values = (Enum[])ce.getDeclaringClass().getEnumConstants();
        int pLoc = ce.ordinal() - 1;
        if (pLoc < 0) {
            pLoc = values.length - 1;
        }
        if (pLoc < 0 || pLoc >= values.length) {
            pLoc = 0;
        }
        return (T)values[pLoc];
    }

    public static <T extends Enum<T>> T next(T ce) {
        Enum[] values = (Enum[])ce.getDeclaringClass().getEnumConstants();
        int pLoc = ce.ordinal() + 1;
        if (pLoc >= values.length) {
            pLoc = 0;
        }
        if (pLoc < 0 || pLoc >= values.length) {
            pLoc = 0;
        }
        return (T)values[pLoc];
    }
}

