/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.Api;
import appeng.spatial.SpatialStorageDimensionIds;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class SpatialStorageChunkGenerator
extends ChunkGenerator {
    public static final Codec<SpatialStorageChunkGenerator> CODEC = RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).xmap(SpatialStorageChunkGenerator::new, SpatialStorageChunkGenerator::getBiomeRegistry).stable().codec();
    private final Registry<Biome> biomeRegistry;
    private final Blockreader columnSample;
    private final BlockState defaultBlockState = Api.instance().definitions().blocks().matrixFrame().block().func_176223_P();

    public SpatialStorageChunkGenerator(Registry<Biome> biomeRegistry) {
        super((BiomeProvider)SpatialStorageChunkGenerator.createBiomeSource(biomeRegistry), SpatialStorageChunkGenerator.createSettings());
        this.biomeRegistry = biomeRegistry;
        Object[] columnSample = new BlockState[256];
        Arrays.fill(columnSample, this.defaultBlockState);
        this.columnSample = new Blockreader((BlockState[])columnSample);
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    private static SingleBiomeProvider createBiomeSource(Registry<Biome> biomeRegistry) {
        return new SingleBiomeProvider((Biome)biomeRegistry.func_243576_d(SpatialStorageDimensionIds.BIOME_KEY));
    }

    public Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    private static DimensionStructuresSettings createSettings() {
        return new DimensionStructuresSettings(Optional.empty(), Collections.emptyMap());
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        this.fillChunk(chunk);
        chunk.func_177427_f(false);
    }

    private void fillChunk(IChunk chunk) {
        BlockPos.Mutable mutPos = new BlockPos.Mutable();
        for (int cx = 0; cx < 16; ++cx) {
            mutPos.func_223471_o(cx);
            for (int cz = 0; cz < 16; ++cz) {
                mutPos.func_223472_q(cz);
                for (int cy = 0; cy < 256; ++cy) {
                    mutPos.func_185336_p(cy);
                    chunk.func_177436_a((BlockPos)mutPos, this.defaultBlockState, false);
                }
            }
        }
    }

    public int func_230356_f_() {
        return 0;
    }

    public ChunkGenerator func_230349_a_(long p_230349_1_) {
        return this;
    }

    public void func_230352_b_(IWorld world, StructureManager accessor, IChunk chunk) {
    }

    public IBlockReader func_230348_a_(int x, int z) {
        return this.columnSample;
    }

    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type heightmapType) {
        return 0;
    }

    public void func_230351_a_(WorldGenRegion region, StructureManager accessor) {
    }

    public void func_230350_a_(long seed, BiomeManager access, IChunk chunk, GenerationStage.Carving carver) {
    }
}

