/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.compass;

import com.google.common.base.Preconditions;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

final class CompassRegion {
    private final int lowX;
    private final int lowZ;
    private final ServerWorld world;
    private SaveData data;

    public CompassRegion(ServerWorld world, int cx, int cz) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
        int region_x = cx >> 10;
        int region_z = cz >> 10;
        this.lowX = region_x << 10;
        this.lowZ = region_z << 10;
        this.openData(false);
    }

    void close() {
        if (this.data != null) {
            this.data = null;
        }
    }

    boolean hasBeacon(int cx, int cz) {
        if (this.data != null) {
            int val = this.read(cx &= 0x3FF, cz &= 0x3FF);
            return val != 0;
        }
        return false;
    }

    void setHasBeacon(int cx, int cz, int cdy, boolean hasBeacon) {
        cx &= 0x3FF;
        cz &= 0x3FF;
        this.openData(hasBeacon);
        if (this.data != null) {
            int val;
            int originalVal = val = this.read(cx, cz);
            val = hasBeacon ? (val |= 1 << cdy) : (val &= ~(1 << cdy));
            if (originalVal != val) {
                this.write(cx, cz, val);
            }
        }
    }

    private void openData(boolean create) {
        if (this.data != null) {
            return;
        }
        String name = this.lowX + "_" + this.lowZ;
        if (create) {
            this.data = (SaveData)this.world.func_217481_x().func_215752_a(() -> new SaveData(name), name);
            if (this.data.bitmap == null) {
                SaveData.access$002(this.data, new byte[0x100000]);
            }
        } else {
            this.data = (SaveData)this.world.func_217481_x().func_215753_b(() -> new SaveData(name), name);
        }
    }

    private int read(int cx, int cz) {
        try {
            return this.data.bitmap[cx + cz * 1024];
        }
        catch (IndexOutOfBoundsException outOfBounds) {
            return 0;
        }
    }

    private void write(int cx, int cz, int val) {
        ((SaveData)this.data).bitmap[cx + cz * 1024] = (byte)val;
        this.data.func_76185_a();
    }

    private static class SaveData
    extends WorldSavedData {
        private static final int BITMAP_LENGTH = 0x100000;
        private byte[] bitmap;

        public SaveData(String name) {
            super(name);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.bitmap = nbt.func_74770_j("b");
            if (this.bitmap.length != 0x100000) {
                throw new IllegalStateException("Invalid bitmap length: " + this.bitmap.length);
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT compound) {
            compound.func_74773_a("b", this.bitmap);
            return compound;
        }

        static /* synthetic */ byte[] access$002(SaveData x0, byte[] x1) {
            x0.bitmap = x1;
            return x1;
        }
    }
}

