/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.Api;
import appeng.server.ISubCommand;
import com.google.common.math.StatsAccumulator;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;

public class TestOreGenCommand
implements ISubCommand {
    private final BlockState quartzOre = Api.INSTANCE.definitions().blocks().quartzOre().block().func_176223_P();
    private final BlockState chargedQuartzOre = Api.INSTANCE.definitions().blocks().quartzOreCharged().block().func_176223_P();

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSource> data, CommandSource sender) {
        BlockPos center;
        ServerWorld world;
        int radius = 1000;
        try {
            ServerPlayerEntity player = sender.func_197035_h();
            world = player.func_71121_q();
            center = new BlockPos(player.func_226277_ct_(), 0.0, player.func_226281_cx_());
        }
        catch (CommandSyntaxException e) {
            world = srv.func_71218_a(World.field_234918_g_);
            center = world.func_241135_u_();
        }
        ChunkPos tl = new ChunkPos(center.func_177982_a(-radius, 0, -radius));
        ChunkPos br = new ChunkPos(center.func_177982_a(radius, 0, radius));
        Stats stats = new Stats();
        for (int cx = tl.field_77276_a; cx <= br.field_77276_a; ++cx) {
            for (int cz = tl.field_77275_b; cz <= br.field_77275_b; ++cz) {
                ChunkPos cp = new ChunkPos(cx, cz);
                this.checkChunk(sender, world, cp, stats);
            }
        }
        AggregatedStats oreCount = AggregatedStats.create(stats.chunks, cs -> cs.quartzOreCount);
        List chunksWithOre = stats.chunks.stream().filter(c -> c.quartzOreCount > 0).collect(Collectors.toList());
        AggregatedStats minHeight = AggregatedStats.create(chunksWithOre, cs -> cs.minHeight);
        AggregatedStats maxHeight = AggregatedStats.create(chunksWithOre, cs -> cs.maxHeight);
        AggregatedStats chargedCount = AggregatedStats.create(chunksWithOre, cs -> cs.chargedOreCount);
        TestOreGenCommand.sendLine(sender, "Checked %d chunks", stats.chunks.size());
        TestOreGenCommand.sendLine(sender, "  Count: %s", oreCount);
        TestOreGenCommand.sendLine(sender, "  Min-Height: %s", minHeight);
        TestOreGenCommand.sendLine(sender, "  Max-Height: %s", maxHeight);
        TestOreGenCommand.sendLine(sender, "  Sub-Type Count: %s", chargedCount);
    }

    private void checkChunk(CommandSource sender, ServerWorld world, ChunkPos cp, Stats stats) {
        IChunk chunk = world.func_217353_a(cp.field_77276_a, cp.field_77275_b, ChunkStatus.field_222617_m, false);
        if (chunk == null) {
            TestOreGenCommand.sendLine(sender, "Skipping chunk %s", cp);
            return;
        }
        ChunkStats chunkStats = new ChunkStats();
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        TestOreGenCommand.sendLine(sender, "Checking chunk %s", cp);
        for (int x = cp.func_180334_c(); x <= cp.func_180332_e(); ++x) {
            blockPos.func_223471_o(x);
            for (int z = cp.func_180333_d(); z <= cp.func_180330_f(); ++z) {
                blockPos.func_223472_q(z);
                for (int y = 0; y < world.func_234938_ad_(); ++y) {
                    blockPos.func_185336_p(y);
                    BlockState state = chunk.func_180495_p((BlockPos)blockPos);
                    if (state != this.quartzOre && state != this.chargedQuartzOre) continue;
                    chunkStats.minHeight = Math.min(chunkStats.minHeight, y);
                    chunkStats.maxHeight = Math.max(chunkStats.maxHeight, y);
                    ++chunkStats.quartzOreCount;
                    if (state != this.chargedQuartzOre) continue;
                    ++chunkStats.chargedOreCount;
                }
            }
        }
        stats.chunks.add(chunkStats);
    }

    private static void sendLine(CommandSource sender, String text, Object ... args) {
        sender.func_197030_a((ITextComponent)new StringTextComponent(String.format(Locale.ROOT, text, args)), true);
    }

    private static class AggregatedStats {
        public final double min;
        public final double max;
        public final double mean;
        public final double stdDev;

        public AggregatedStats(double min, double max, double mean, double stdDev) {
            this.min = min;
            this.max = max;
            this.mean = mean;
            this.stdDev = stdDev;
        }

        public static <T> AggregatedStats create(List<T> values, ToDoubleFunction<T> getter) {
            if (values.isEmpty()) {
                return new AggregatedStats(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            }
            StatsAccumulator accumulator = new StatsAccumulator();
            for (T value : values) {
                accumulator.add(getter.applyAsDouble(value));
            }
            return new AggregatedStats(accumulator.min(), accumulator.max(), accumulator.mean(), accumulator.populationStandardDeviation());
        }

        public String toString() {
            if (Double.isNaN(this.min)) {
                return "Invalid";
            }
            return String.format(Locale.ROOT, "min=%.2f, max=%.2f, mean=%.2f, stdDev=%.2f", this.min, this.max, this.mean, this.stdDev);
        }
    }

    private static class ChunkStats {
        public int quartzOreCount = 0;
        public int chargedOreCount = 0;
        public int minHeight = Integer.MAX_VALUE;
        public int maxHeight = Integer.MIN_VALUE;

        private ChunkStats() {
        }
    }

    private static class Stats {
        public final List<ChunkStats> chunks = new ArrayList<ChunkStats>();

        private Stats() {
        }
    }
}

