/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.core.AEConfig;
import appeng.recipes.handlers.GrinderOptionalResult;
import appeng.recipes.handlers.GrinderRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GrinderRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<GrinderRecipe> {
    public static final GrinderRecipeSerializer INSTANCE = new GrinderRecipeSerializer();

    private GrinderRecipeSerializer() {
    }

    public GrinderRecipe read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonObject inputObj = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)inputObj);
        int ingredientCount = 1;
        if (inputObj.has("count")) {
            ingredientCount = inputObj.get("count").getAsInt();
        }
        JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ItemStack primaryResult = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)result, (String)"primary"));
        JsonArray optionalResultsJson = JSONUtils.func_151213_a((JsonObject)result, (String)"optional", null);
        List<GrinderOptionalResult> optionalResults = Collections.emptyList();
        if (optionalResultsJson != null) {
            optionalResults = new ArrayList(optionalResultsJson.size());
            for (JsonElement optionalResultJson : optionalResultsJson) {
                if (!optionalResultJson.isJsonObject()) {
                    throw new IllegalStateException("Entry in optional result list should be an object.");
                }
                ItemStack optionalResultItem = ShapedRecipe.func_199798_a((JsonObject)optionalResultJson.getAsJsonObject());
                float optionalChance = JSONUtils.func_151221_a((JsonObject)optionalResultJson.getAsJsonObject(), (String)"percentageChance", (float)AEConfig.instance().getOreDoublePercentage()) / 100.0f;
                optionalResults.add(new GrinderOptionalResult(optionalChance, optionalResultItem));
            }
        }
        int turns = JSONUtils.func_151208_a((JsonObject)json, (String)"turns", (int)8);
        return new GrinderRecipe(recipeId, group, ingredient, ingredientCount, primaryResult, turns, optionalResults);
    }

    @Nullable
    public GrinderRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        int ingredientCount = buffer.func_150792_a();
        ItemStack result = buffer.func_150791_c();
        int turns = buffer.func_150792_a();
        int optionalResultsCount = buffer.func_150792_a();
        ArrayList<GrinderOptionalResult> optionalResults = new ArrayList<GrinderOptionalResult>(optionalResultsCount);
        for (int i = 0; i < optionalResultsCount; ++i) {
            float chance = buffer.readFloat();
            ItemStack optionalResult = buffer.func_150791_c();
            optionalResults.add(new GrinderOptionalResult(chance, optionalResult));
        }
        return new GrinderRecipe(recipeId, group, ingredient, ingredientCount, result, turns, optionalResults);
    }

    public void write(PacketBuffer buffer, GrinderRecipe recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        recipe.getIngredient().func_199564_a(buffer);
        buffer.func_150787_b(recipe.getIngredientCount());
        buffer.func_150788_a(recipe.func_77571_b());
        buffer.func_150787_b(recipe.getTurns());
        List<GrinderOptionalResult> optionalResults = recipe.getOptionalResults();
        buffer.func_150787_b(optionalResults.size());
        for (GrinderOptionalResult optionalResult : optionalResults) {
            buffer.writeFloat(optionalResult.getChance());
            buffer.func_150788_a(optionalResult.getResult());
        }
    }

    static {
        INSTANCE.setRegistryName(GrinderRecipe.TYPE_ID);
    }
}

