/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartModel;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class CraftingTerminalPart
extends AbstractTerminalPart {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedenergistics2", "part/crafting_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedenergistics2", "part/crafting_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    private final AppEngInternalInventory craftingGrid = new AppEngInternalInventory(this, 9);

    public CraftingTerminalPart(ItemStack is) {
        super(is);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.craftingGrid) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        super.readFromNBT(data);
        this.craftingGrid.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        super.writeToNBT(data);
        this.craftingGrid.writeToNBT(data, "craftingGrid");
    }

    @Override
    public ContainerType<?> getContainerType(PlayerEntity p) {
        if (Platform.checkPermissions(p, this, SecurityPermissions.CRAFT, false)) {
            return CraftingTermContainer.TYPE;
        }
        return MEMonitorableContainer.TYPE;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.craftingGrid;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }
}

