/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.PlayerSource;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractMonitorPart;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ConversionMonitorPart
extends AbstractMonitorPart {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_on");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_off");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL);

    public ConversionMonitorPart(ItemStack is) {
        super(is);
    }

    @Override
    public boolean onPartActivate(PlayerEntity player, Hand hand, Vector3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        ItemStack eq = player.func_184586_b(hand);
        if (this.isLocked()) {
            if (eq.func_190926_b()) {
                this.insertItem(player, hand, true);
            } else {
                if (Platform.isWrench(player, eq, this.getLocation().getPos()) && (this.getDisplayed() == null || !this.getDisplayed().equals(eq))) {
                    return super.onPartActivate(player, hand, pos);
                }
                this.insertItem(player, hand, false);
            }
        } else if (this.getDisplayed() != null && this.getDisplayed().equals(eq)) {
            this.insertItem(player, hand, false);
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        return true;
    }

    @Override
    public boolean onClicked(PlayerEntity player, Hand hand, Vector3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.getDisplayed() != null) {
            this.extractItem(player, this.getDisplayed().getDefinition().func_77976_d());
        }
        return true;
    }

    @Override
    public boolean onShiftClicked(PlayerEntity player, Hand hand, Vector3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.getDisplayed() != null) {
            this.extractItem(player, 1);
        }
        return true;
    }

    private void insertItem(PlayerEntity player, Hand hand, boolean allItems) {
        try {
            IEnergyGrid energy = this.getProxy().getEnergy();
            IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (allItems) {
                if (this.getDisplayed() != null) {
                    IAEItemStack input = this.getDisplayed().copy();
                    PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.field_71071_by);
                    for (int x = 0; x < inv.getSlots(); ++x) {
                        ItemStack canExtract;
                        ItemStack targetStack = inv.getStackInSlot(x);
                        if (!input.equals(targetStack) || (canExtract = inv.extractItem(x, targetStack.func_190916_E(), true)).func_190926_b()) continue;
                        input.setStackSize(canExtract.func_190916_E());
                        IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                        inv.extractItem(x, failedToInsert == null ? canExtract.func_190916_E() : canExtract.func_190916_E() - (int)failedToInsert.getStackSize(), false);
                    }
                }
            } else {
                AEItemStack input = AEItemStack.fromItemStack(player.func_184586_b(hand));
                IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                player.func_184611_a(hand, failedToInsert == null ? ItemStack.field_190927_a : failedToInsert.createItemStack());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void extractItem(PlayerEntity player, int count) {
        IAEItemStack input = this.getDisplayed();
        if (input != null) {
            try {
                if (!this.getProxy().isActive()) {
                    return;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                input.setStackSize(count);
                IAEItemStack retrieved = Platform.poweredExtraction(energy, cell, input, new PlayerSource(player, this));
                if (retrieved != null) {
                    ItemStack newItems = retrieved.createItemStack();
                    InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(player);
                    newItems = adaptor.addItems(newItems);
                    if (!newItems.func_190926_b()) {
                        TileEntity te = this.getTile();
                        List<ItemStack> list = Collections.singletonList(newItems);
                        Platform.spawnDrops(player.field_70170_p, te.func_174877_v().func_177972_a(this.getSide().getFacing()), list);
                    }
                    if (player.field_71070_bA != null) {
                        player.field_71070_bA.func_75142_b();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }
}

