/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.core.sync.packets.ItemTransitionEffectPacket;
import appeng.hooks.TickHandler;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.BasicStatePart;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class AnnihilationPlanePart
extends BasicStatePart
implements IGridTickable,
IWorldCallable<TickRateModulation> {
    public static final ResourceLocation TAG_BLACKLIST = new ResourceLocation("appliedenergistics2", "blacklisted/annihilation_plane");
    private static final ITag.INamedTag<Block> BLOCK_BLACKLIST = BlockTags.func_199894_a((String)TAG_BLACKLIST.toString());
    private static final ITag.INamedTag<Item> ITEM_BLACKLIST = ItemTags.func_199901_a((String)TAG_BLACKLIST.toString());
    private static final PlaneModels MODELS = new PlaneModels("part/annihilation_plane", "part/annihilation_plane_on");
    private final IActionSource mySrc = new MachineSource(this);
    private boolean isAccepting = true;
    private boolean breaking = false;
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper(this);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public AnnihilationPlanePart(ItemStack is) {
        super(is);
    }

    @Override
    public TickRateModulation call(World world) {
        this.breaking = false;
        return this.breakBlock(true);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        if (bch.isBBCollision()) {
            bch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 15.5);
            return;
        }
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.refresh();
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (this.isAccepting && entity instanceof ItemEntity && entity.func_70089_S() && Platform.isServer() && this.getProxy().isActive()) {
            boolean changed;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (AnnihilationPlanePart.isItemBlacklisted(itemEntity.func_92059_d().func_77973_b())) {
                return;
            }
            boolean capture = false;
            BlockPos pos = this.getTile().func_174877_v();
            double posYMiddle = (entity.func_174813_aQ().field_72338_b + entity.func_174813_aQ().field_72337_e) / 2.0;
            switch (this.getSide()) {
                case DOWN: 
                case UP: {
                    if (!(entity.func_226277_ct_() > (double)pos.func_177958_n()) || !(entity.func_226277_ct_() < (double)(pos.func_177958_n() + 1)) || !(entity.func_226281_cx_() > (double)pos.func_177952_p()) || !(entity.func_226281_cx_() < (double)(pos.func_177952_p() + 1)) || !(entity.func_226278_cu_() > (double)pos.func_177956_o() + 0.9 && this.getSide() == AEPartLocation.UP) && (!(entity.func_226278_cu_() < (double)pos.func_177956_o() + 0.1) || this.getSide() != AEPartLocation.DOWN)) break;
                    capture = true;
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    if (!(entity.func_226277_ct_() > (double)pos.func_177958_n()) || !(entity.func_226277_ct_() < (double)(pos.func_177958_n() + 1)) || !(posYMiddle > (double)pos.func_177956_o()) || !(posYMiddle < (double)(pos.func_177956_o() + 1)) || !(entity.func_226281_cx_() > (double)pos.func_177952_p() + 0.9 && this.getSide() == AEPartLocation.SOUTH) && (!(entity.func_226281_cx_() < (double)pos.func_177952_p() + 0.1) || this.getSide() != AEPartLocation.NORTH)) break;
                    capture = true;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (!(entity.func_226281_cx_() > (double)pos.func_177952_p()) || !(entity.func_226281_cx_() < (double)(pos.func_177952_p() + 1)) || !(posYMiddle > (double)pos.func_177956_o()) || !(posYMiddle < (double)(pos.func_177956_o() + 1)) || !(entity.func_226277_ct_() > (double)pos.func_177958_n() + 0.9 && this.getSide() == AEPartLocation.EAST) && (!(entity.func_226277_ct_() < (double)pos.func_177958_n() + 0.1) || this.getSide() != AEPartLocation.WEST)) break;
                    capture = true;
                    break;
                }
            }
            if (capture && (changed = this.storeEntityItem(itemEntity))) {
                AppEng.proxy.sendToAllNearExcept(null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, this.getTile().func_145831_w(), new ItemTransitionEffectPacket(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.getSide().getOpposite()));
            }
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    private boolean storeEntityItem(ItemEntity entityItem) {
        if (entityItem.func_70089_S()) {
            IAEItemStack overflow = this.storeItemStack(entityItem.func_92059_d());
            return this.handleOverflow(entityItem, overflow);
        }
        return false;
    }

    private IAEItemStack storeItemStack(ItemStack item) {
        AEItemStack itemToStore = AEItemStack.fromItemStack(item);
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            IEnergyGrid energy = this.getProxy().getEnergy();
            IAEItemStack overflow = Platform.poweredInsert(energy, storage.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)), itemToStore, this.mySrc);
            this.isAccepting = overflow == null;
            return overflow;
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    private boolean handleOverflow(ItemEntity entityItem, IAEItemStack overflow) {
        int newStackSize;
        if (overflow == null || overflow.getStackSize() == 0L) {
            entityItem.func_70106_y();
            return true;
        }
        int oldStackSize = entityItem.func_92059_d().func_190916_E();
        boolean changed = oldStackSize != (newStackSize = (int)overflow.getStackSize());
        entityItem.func_92059_d().func_190920_e(newStackSize);
        return changed;
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    private TickRateModulation breakBlock(boolean modulate) {
        if (this.isAccepting && this.getProxy().isActive()) {
            try {
                TileEntity te = this.getTile();
                ServerWorld w = (ServerWorld)te.func_145831_w();
                BlockPos pos = te.func_174877_v().func_177972_a(this.getSide().getFacing());
                IEnergyGrid energy = this.getProxy().getEnergy();
                BlockState blockState = w.func_180495_p(pos);
                if (this.canHandleBlock(w, pos, blockState)) {
                    List<ItemStack> items = this.obtainBlockDrops(w, pos);
                    float requiredPower = this.calculateEnergyUsage(w, pos, items);
                    boolean hasPower = energy.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
                    boolean canStore = this.canStoreItemStacks(items);
                    if (hasPower && canStore) {
                        if (modulate) {
                            this.performBreakBlock(w, pos, blockState, energy, requiredPower, items);
                        } else {
                            this.breaking = true;
                            TickHandler.instance().addCallable((IWorld)this.getTile().func_145831_w(), this);
                        }
                        return TickRateModulation.URGENT;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.IDLE;
    }

    private void performBreakBlock(ServerWorld w, BlockPos pos, BlockState blockState, IEnergyGrid energy, float requiredPower, List<ItemStack> items) {
        if (!this.breakBlockAndStoreExtraItems(w, pos)) {
            return;
        }
        for (ItemStack item : items) {
            IAEItemStack overflow = this.storeItemStack(item);
            if (overflow == null) continue;
            Platform.spawnDrops((World)w, pos, Collections.singletonList(overflow.createItemStack()));
        }
        energy.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
        AppEng.proxy.sendToAllNearExcept(null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, (World)w, new BlockTransitionEffectPacket(pos, blockState, this.getSide().getOpposite(), BlockTransitionEffectPacket.SoundMode.NONE));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.getMin(), TickRates.AnnihilationPlane.getMax(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.breaking) {
            return TickRateModulation.URGENT;
        }
        this.isAccepting = true;
        return this.breakBlock(false);
    }

    private boolean canHandleBlock(ServerWorld w, BlockPos pos, BlockState state) {
        if (state.isAir((IBlockReader)w, pos)) {
            return false;
        }
        if (AnnihilationPlanePart.isBlockBlacklisted(state.func_177230_c())) {
            return false;
        }
        Material material = state.func_185904_a();
        float hardness = state.func_185887_b((IBlockReader)w, pos);
        boolean ignoreMaterials = material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151586_h || material.func_76224_d();
        return !ignoreMaterials && hardness >= 0.0f && w.func_175667_e(pos) && w.func_175660_a(Platform.getPlayer(w), pos);
    }

    protected List<ItemStack> obtainBlockDrops(ServerWorld w, BlockPos pos) {
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)w);
        BlockState state = w.func_180495_p(pos);
        ItemStack harvestTool = this.createHarvestTool(state);
        if (harvestTool == null) {
            if (!state.func_235783_q_()) {
                harvestTool = ItemStack.field_190927_a;
            } else {
                return Collections.emptyList();
            }
        }
        TileEntity te = w.func_175625_s(pos);
        return Block.func_220077_a((BlockState)state, (ServerWorld)w, (BlockPos)pos, (TileEntity)te, (Entity)fakePlayer, (ItemStack)harvestTool);
    }

    protected float calculateEnergyUsage(ServerWorld w, BlockPos pos, List<ItemStack> items) {
        BlockState state = w.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)w, pos);
        float requiredEnergy = 1.0f + hardness;
        for (ItemStack is : items) {
            requiredEnergy += (float)is.func_190916_E();
        }
        return requiredEnergy;
    }

    private boolean canStoreItemStacks(List<ItemStack> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            for (ItemStack itemStack : itemStacks) {
                AEItemStack itemToTest = AEItemStack.fromItemStack(itemStack);
                IAEItemStack overflow = storage.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)).injectItems(itemToTest, Actionable.SIMULATE, this.mySrc);
                if (overflow != null && itemToTest.getStackSize() <= overflow.getStackSize()) continue;
                canStore = true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private boolean breakBlockAndStoreExtraItems(ServerWorld w, BlockPos pos) {
        if (!w.func_175655_b(pos, false)) {
            return false;
        }
        AxisAlignedBB box = new AxisAlignedBB(pos).func_186662_g(0.2);
        for (Object ei : w.func_217357_a(ItemEntity.class, box)) {
            if (!(ei instanceof ItemEntity)) continue;
            ItemEntity entityItem = (ItemEntity)ei;
            this.storeEntityItem(entityItem);
        }
        return true;
    }

    private void refresh() {
        this.isAccepting = true;
        this.getTile().requestModelDataUpdate();
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new PlaneModelData(this.getConnections());
    }

    protected ItemStack createHarvestTool(BlockState state) {
        ToolType harvestToolType = state.func_177230_c().getHarvestTool(state);
        if (harvestToolType == ToolType.AXE) {
            return new ItemStack((IItemProvider)Items.field_151056_x, 1);
        }
        if (harvestToolType == ToolType.SHOVEL) {
            return new ItemStack((IItemProvider)Items.field_151047_v, 1);
        }
        if (harvestToolType == ToolType.PICKAXE) {
            return new ItemStack((IItemProvider)Items.field_151046_w, 1);
        }
        return null;
    }

    public static boolean isBlockBlacklisted(Block b) {
        return BLOCK_BLACKLIST.func_230235_a_((Object)b);
    }

    public static boolean isItemBlacklisted(Item i) {
        return ITEM_BLACKLIST.func_230235_a_((Object)i);
    }
}

