/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.definitions.IItems;
import appeng.api.definitions.ITileDefinition;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ClickPacket;
import appeng.core.sync.packets.PartPlacementPacket;
import appeng.facade.IFacadeItem;
import appeng.util.LookDirection;
import appeng.util.Platform;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PartPlacement {
    private static float eyeHeight = 0.0f;
    private final ThreadLocal<Object> placing = new ThreadLocal();
    private boolean wasCanceled = false;

    /*
     * Enabled aggressive block sorting
     */
    public static ActionResultType place(ItemStack held, BlockPos pos, Direction side, PlayerEntity player, Hand hand, World world, PlaceType pass, int depth) {
        DimensionalCoord dc;
        Vector3d hitVec;
        SelectedPart sPart;
        IFacadePart fp;
        if (depth > 3) {
            return ActionResultType.FAIL;
        }
        LookDirection dir = Platform.getPlayerRay(player);
        RayTraceContext rtc = new RayTraceContext(dir.getA(), dir.getB(), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player);
        BlockRayTraceResult mop = world.func_217299_a(rtc);
        BlockItemUseContext useContext = new BlockItemUseContext(new ItemUseContext(player, hand, mop));
        if (!held.func_190926_b() && Platform.isWrench(player, held, pos) && player.func_213453_ef()) {
            if (!Platform.hasPermissions(new DimensionalCoord(world, pos), player)) {
                return ActionResultType.FAIL;
            }
            TileEntity tile = world.func_175625_s(pos);
            IPartHost host = null;
            if (tile instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            if (host == null) return ActionResultType.FAIL;
            if (world.field_72995_K) {
                player.func_184609_a(hand);
                NetworkHandler.instance().sendToServer(new PartPlacementPacket(pos, side, PartPlacement.getEyeOffset(player), hand));
                return ActionResultType.SUCCESS;
            }
            if (mop.func_216346_c() != RayTraceResult.Type.BLOCK) return ActionResultType.SUCCESS;
            ArrayList<ItemStack> is = new ArrayList<ItemStack>();
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.func_216347_e().func_72441_c((double)(-mop.func_216350_a().func_177958_n()), (double)(-mop.func_216350_a().func_177956_o()), (double)(-mop.func_216350_a().func_177952_p())));
            if (sp.part != null) {
                is.add(sp.part.getItemStack(PartItemStack.WRENCH));
                sp.part.getDrops(is, true);
                host.removePart(sp.side, false);
            }
            if (sp.facade != null) {
                is.add(sp.facade.getItemStack());
                host.getFacadeContainer().removeFacade(host, sp.side);
                Platform.notifyBlocksOfNeighbors(world, pos);
            }
            if (host.isEmpty()) {
                host.cleanup();
            }
            if (is.isEmpty()) return ActionResultType.SUCCESS;
            Platform.spawnDrops(world, pos, is);
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        IPartHost host = null;
        if (tile instanceof IPartHost) {
            host = (IPartHost)tile;
        }
        if (!held.func_190926_b() && (fp = PartPlacement.isFacade(held, AEPartLocation.fromFacing(side))) != null) {
            if (host == null) return ActionResultType.FAIL;
            if (world.field_72995_K) {
                player.func_184609_a(hand);
                NetworkHandler.instance().sendToServer(new PartPlacementPacket(pos, side, PartPlacement.getEyeOffset(player), hand));
                return ActionResultType.SUCCESS;
            }
            if (host.getPart(AEPartLocation.INTERNAL) == null) {
                return ActionResultType.FAIL;
            }
            if (!host.canAddPart(held, AEPartLocation.fromFacing(side))) return ActionResultType.FAIL;
            if (!host.getFacadeContainer().addFacade(fp)) return ActionResultType.FAIL;
            host.markForSave();
            host.markForUpdate();
            if (player.func_184812_l_()) return ActionResultType.CONSUME;
            held.func_190917_f(-1);
            if (held.func_190916_E() != 0) return ActionResultType.CONSUME;
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held, hand));
            return ActionResultType.CONSUME;
        }
        if (held.func_190926_b() && host != null && player.func_213453_ef() && world.func_175623_d(pos) && mop.func_216346_c() == RayTraceResult.Type.BLOCK && (sPart = PartPlacement.selectPart(player, host, hitVec = mop.func_216347_e().func_72441_c((double)(-mop.func_216350_a().func_177958_n()), (double)(-mop.func_216350_a().func_177956_o()), (double)(-mop.func_216350_a().func_177952_p())))) != null && sPart.part != null && sPart.part.onShiftActivate(player, hand, hitVec)) {
            if (!world.field_72995_K) return ActionResultType.SUCCESS;
            NetworkHandler.instance().sendToServer(new PartPlacementPacket(pos, side, PartPlacement.getEyeOffset(player), hand));
            return ActionResultType.SUCCESS;
        }
        if (held.func_190926_b()) return ActionResultType.PASS;
        if (!(held.func_77973_b() instanceof IPartItem)) {
            return ActionResultType.PASS;
        }
        BlockPos te_pos = pos;
        ITileDefinition multiPart = Api.instance().definitions().blocks().multiPart();
        if (host == null && pass == PlaceType.PLACE_ITEM) {
            Direction offset = null;
            BlockState blockState = world.func_180495_p(pos);
            if (!blockState.isAir((IBlockReader)world, pos) && !blockState.func_196953_a(useContext)) {
                offset = side;
                if (Platform.isServer()) {
                    side = side.func_176734_d();
                }
            }
            if ((tile = world.func_175625_s(te_pos = offset == null ? pos : pos.func_177972_a(offset))) instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            ItemStack multiPartStack = multiPart.stack(1);
            Block multiPartBlock2 = multiPart.block();
            BlockItem multiPartBlockItem = multiPart.blockItem();
            boolean hostIsNotPresent = host == null;
            BlockState multiPartBlockState = multiPartBlock2.func_176223_P();
            boolean canMultiPartBePlaced = multiPartBlockState.func_196955_c((IWorldReader)world, te_pos);
            BlockItemUseContext mpUseCtx = new BlockItemUseContext((ItemUseContext)new DirectionalPlaceContext(world, te_pos, side, multiPartStack, side));
            if (hostIsNotPresent && canMultiPartBePlaced && multiPartBlockItem.func_195942_a(mpUseCtx).func_226246_a_()) {
                if (world.field_72995_K) {
                    player.func_184609_a(hand);
                    NetworkHandler.instance().sendToServer(new PartPlacementPacket(pos, side, PartPlacement.getEyeOffset(player), hand));
                    return ActionResultType.SUCCESS;
                }
                tile = world.func_175625_s(te_pos);
                if (tile instanceof IPartHost) {
                    host = (IPartHost)tile;
                }
                pass = PlaceType.INTERACT_SECOND_PASS;
            } else if (host != null && !host.canAddPart(held, AEPartLocation.fromFacing(side))) {
                return ActionResultType.FAIL;
            }
        }
        if (host == null) {
            return ActionResultType.PASS;
        }
        if (!host.canAddPart(held, AEPartLocation.fromFacing(side))) {
            PlaceType placeType;
            BlockState blkState;
            if (pass != PlaceType.INTERACT_FIRST_PASS) {
                if (pass != PlaceType.PLACE_ITEM) return ActionResultType.PASS;
            }
            if (!(blkState = world.func_180495_p(te_pos = pos.func_177972_a(side))).isAir((IBlockReader)world, te_pos) && !blkState.func_196953_a(useContext)) {
                if (host == null) return ActionResultType.PASS;
            }
            Direction direction = side.func_176734_d();
            if (pass == PlaceType.INTERACT_FIRST_PASS) {
                placeType = PlaceType.INTERACT_SECOND_PASS;
                return PartPlacement.place(held, te_pos, direction, player, hand, world, placeType, depth + 1);
            }
            placeType = PlaceType.PLACE_ITEM;
            return PartPlacement.place(held, te_pos, direction, player, hand, world, placeType, depth + 1);
        }
        if (world.field_72995_K) {
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.func_216347_e().func_72441_c((double)(-mop.func_216350_a().func_177958_n()), (double)(-mop.func_216350_a().func_177956_o()), (double)(-mop.func_216350_a().func_177952_p())));
            if (sp.part != null && !player.func_213453_ef() && sp.part.onActivate(player, hand, mop.func_216347_e())) {
                return ActionResultType.FAIL;
            }
        }
        if (!Platform.hasPermissions(dc = host.getLocation(), player)) {
            return ActionResultType.FAIL;
        }
        AEPartLocation mySide = host.addPart(held, AEPartLocation.fromFacing(side), player, hand);
        if (mySide == null) return ActionResultType.SUCCESS;
        multiPart.maybeBlock().ifPresent(multiPartBlock -> {
            BlockState blockState = world.func_180495_p(pos);
            SoundType ss = multiPartBlock.getSoundType(blockState, (IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(null, pos, ss.func_185841_e(), SoundCategory.BLOCKS, (ss.func_185843_a() + 1.0f) / 2.0f, ss.func_185847_b() * 0.8f);
        });
        if (player.func_184812_l_()) return ActionResultType.SUCCESS;
        held.func_190917_f(-1);
        if (held.func_190916_E() != 0) return ActionResultType.SUCCESS;
        player.func_184611_a(hand, ItemStack.field_190927_a);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held, hand));
        return ActionResultType.SUCCESS;
    }

    private static float getEyeOffset(PlayerEntity p) {
        if (p.field_70170_p.field_72995_K) {
            return Platform.getEyeOffset(p);
        }
        return PartPlacement.getEyeHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SelectedPart selectPart(PlayerEntity player, IPartHost host, Vector3d pos) {
        AppEng.proxy.setPartInteractionPlayer(player);
        try {
            SelectedPart selectedPart = host.selectPart(pos);
            return selectedPart;
        }
        finally {
            AppEng.proxy.setPartInteractionPlayer(null);
        }
    }

    public static IFacadePart isFacade(ItemStack held, AEPartLocation side) {
        if (held.func_77973_b() instanceof IFacadeItem) {
            return ((IFacadeItem)held.func_77973_b()).createPartFromItemStack(held, side);
        }
        return null;
    }

    @SubscribeEvent
    public void playerInteract(TickEvent.ClientTickEvent event) {
        this.wasCanceled = false;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        if (event instanceof PlayerInteractEvent.RightClickEmpty && event.getPlayer().field_70170_p.field_72995_K) {
            RayTraceResult mop = Platform.rayTrace(event.getPlayer(), true, false);
            Minecraft mc = Minecraft.func_71410_x();
            float f = 1.0f;
            double d0 = mc.field_71442_b.func_78757_d();
            Vector3d vec3 = mc.func_175606_aa().func_174824_e(1.0f);
            if (mop instanceof BlockRayTraceResult && mop.func_216347_e().func_72438_d(vec3) < d0) {
                World w = event.getEntity().field_70170_p;
                BlockRayTraceResult brtr = (BlockRayTraceResult)mop;
                TileEntity te = w.func_175625_s(brtr.func_216350_a());
                if (te instanceof IPartHost && this.wasCanceled) {
                    event.setCanceled(true);
                }
            } else {
                ItemStack held = event.getPlayer().func_184586_b(event.getHand());
                IItems items = Api.instance().definitions().items();
                boolean supportedItem = items.memoryCard().isSameAs(held);
                if (event.getPlayer().func_213453_ef() && !held.func_190926_b() && (supportedItem |= items.colorApplicator().isSameAs(held))) {
                    NetworkHandler.instance().sendToServer(new ClickPacket(event.getHand()));
                }
            }
        } else if (event instanceof PlayerInteractEvent.RightClickBlock && !event.getPlayer().field_70170_p.field_72995_K) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            ItemStack held = event.getPlayer().func_184586_b(event.getHand());
            if (PartPlacement.place(held, event.getPos(), event.getFace(), event.getPlayer(), event.getHand(), event.getPlayer().field_70170_p, PlaceType.INTERACT_FIRST_PASS, 0) == ActionResultType.SUCCESS) {
                event.setCanceled(true);
                this.wasCanceled = true;
            }
            this.placing.set(null);
        }
    }

    private static float getEyeHeight() {
        return eyeHeight;
    }

    public static void setEyeHeight(float eyeHeight) {
        PartPlacement.eyeHeight = eyeHeight;
    }

    public static enum PlaceType {
        PLACE_ITEM,
        INTERACT_FIRST_PASS,
        INTERACT_SECOND_PASS;

    }
}

