/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.util.DimensionalCoord;
import appeng.block.misc.TinyTNTBlock;
import appeng.container.ContainerNull;
import appeng.core.AEConfig;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.InWorldToolOperationResult;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntropyManipulatorItem
extends AEBasePoweredItem
implements IBlockTool {
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> heatUp = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> coolDown = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();

    public EntropyManipulatorItem(Item.Properties props) {
        super(AEConfig.instance().getEntropyManipulatorBattery(), props);
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150348_b), new InWorldToolOperationResult(Blocks.field_150347_e.func_176223_P()));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_196696_di), new InWorldToolOperationResult(Blocks.field_196700_dk.func_176223_P()));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150353_l, (Fluid)Fluids.field_204547_b), new InWorldToolOperationResult(Blocks.field_150343_Z.func_176223_P()));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150353_l, (Fluid)Fluids.field_207213_d), new InWorldToolOperationResult(Blocks.field_150343_Z.func_176223_P()));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_196658_i), new InWorldToolOperationResult(Blocks.field_150346_d.func_176223_P()));
        ArrayList<ItemStack> snowBalls = new ArrayList<ItemStack>();
        snowBalls.add(new ItemStack((IItemProvider)Items.field_151126_ay));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150355_j, (Fluid)Fluids.field_207212_b), new InWorldToolOperationResult(null, snowBalls));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150355_j, (Fluid)Fluids.field_204546_a), new InWorldToolOperationResult(Blocks.field_150432_aD.func_176223_P()));
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150432_aD), new InWorldToolOperationResult(Blocks.field_150355_j.func_176223_P()));
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150355_j, (Fluid)Fluids.field_204546_a), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150355_j, (Fluid)Fluids.field_207212_b), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150433_aE), new InWorldToolOperationResult((BlockState)Blocks.field_150355_j.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208132_ag, (Comparable)Integer.valueOf(7)), (Fluid)Fluids.field_207212_b));
    }

    private void heat(Block block, Fluid fluid, World w, BlockPos pos) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(block, Fluids.field_204541_a));
        }
        if (r.getBlockState() != null) {
            w.func_180501_a(pos, r.getBlockState(), 3);
        } else {
            w.func_180501_a(pos, Fluids.field_204541_a.func_207188_f().func_206883_i(), 3);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, pos, r.getDrops());
        }
        if (!w.field_72995_K) {
            w.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (w.field_73012_v.nextFloat() - w.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                w.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean canHeat(Block block, Fluid fluid) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(block, Fluids.field_204541_a));
        }
        return r != null;
    }

    private void cool(Block block, Fluid fluid, World w, BlockPos pos) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(block, Fluids.field_204541_a));
        }
        if (r.getBlockState() != null) {
            w.func_180501_a(pos, r.getBlockState(), 3);
        } else {
            w.func_217377_a(pos, false);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, pos, r.getDrops());
        }
    }

    private boolean canCool(Block block, Fluid fluid) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(block, Fluids.field_204541_a));
        }
        return r != null;
    }

    public boolean func_77644_a(ItemStack item, LivingEntity target, LivingEntity hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            target.func_70015_d(8);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity p, Hand hand) {
        BlockRayTraceResult target = EntropyManipulatorItem.func_219968_a((World)w, (PlayerEntity)p, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (target.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.FAIL, (Object)p.func_184586_b(hand));
        }
        BlockPos pos = target.func_216350_a();
        BlockState state = w.func_180495_p(pos);
        if ((state.func_185904_a() == Material.field_151587_i || state.func_185904_a() == Material.field_151586_h) && Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
            ItemUseContext context = new ItemUseContext(p, hand, target);
            this.func_195939_a(context);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)p.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World w = context.func_195991_k();
        ItemStack item = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        PlayerEntity p = context.func_195999_j();
        boolean tryBoth = false;
        if (p == null) {
            if (w.field_72995_K) {
                return ActionResultType.FAIL;
            }
            p = Platform.getPlayer((ServerWorld)w);
            tryBoth = true;
        }
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.func_175151_a(pos, side, item)) {
                return ActionResultType.FAIL;
            }
            Block block = w.func_180495_p(pos).func_177230_c();
            Fluid fluid = w.func_204610_c(pos).func_206886_c();
            if ((tryBoth || p.func_213453_ef()) && this.canCool(block, fluid)) {
                this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                this.cool(block, fluid, w, pos);
                return ActionResultType.SUCCESS;
            }
            if (tryBoth || !p.func_213453_ef()) {
                if (block instanceof TNTBlock) {
                    w.func_217377_a(pos, false);
                    block.catchFire(w.func_180495_p(pos), w, pos, context.func_196000_l(), (LivingEntity)p);
                    return ActionResultType.SUCCESS;
                }
                if (block instanceof TinyTNTBlock) {
                    w.func_217377_a(pos, false);
                    ((TinyTNTBlock)block).startFuse(w, pos, (LivingEntity)p);
                    return ActionResultType.SUCCESS;
                }
                if (this.canHeat(block, fluid)) {
                    this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                    this.heat(block, fluid, w, pos);
                    return ActionResultType.SUCCESS;
                }
                ItemStack[] stack = Platform.getBlockDrops(w, pos);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                boolean hasFurnaceable = false;
                boolean canFurnaceable = true;
                for (ItemStack i : stack) {
                    CraftingInventory tempInv = new CraftingInventory((Container)new ContainerNull(), 1, 1);
                    tempInv.func_70299_a(0, i);
                    Optional recipe = w.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)tempInv, w);
                    if (recipe.isPresent()) {
                        ItemStack result = ((FurnaceRecipe)recipe.get()).func_77572_b((IInventory)tempInv);
                        if (result.func_77973_b() instanceof BlockItem && Block.func_149634_a((Item)result.func_77973_b()) == block) {
                            canFurnaceable = false;
                        }
                        hasFurnaceable = true;
                        out.add(result);
                        continue;
                    }
                    canFurnaceable = false;
                    out.add(i);
                }
                if (hasFurnaceable && canFurnaceable) {
                    this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                    InWorldToolOperationResult or = InWorldToolOperationResult.getBlockOperationResult(out.toArray(new ItemStack[0]));
                    w.func_184148_a(p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    if (or.getBlockState() == null) {
                        w.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    } else {
                        w.func_180501_a(pos, or.getBlockState(), 3);
                    }
                    if (or.getDrops() != null) {
                        Platform.spawnDrops(w, pos, or.getDrops());
                    }
                    return ActionResultType.SUCCESS;
                }
                BlockPos offsetPos = pos.func_177972_a(side);
                if (!p.func_175151_a(offsetPos, side, item)) {
                    return ActionResultType.FAIL;
                }
                if (w.func_175623_d(offsetPos)) {
                    this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                    w.func_184148_a(p, (double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o() + 0.5, (double)offsetPos.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    w.func_175656_a(offsetPos, Blocks.field_150480_ab.func_176223_P());
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private static class InWorldToolOperationIngredient {
        private final Block block;
        private final Fluid fluid;

        public InWorldToolOperationIngredient(Block block) {
            this(block, Fluids.field_204541_a);
        }

        public InWorldToolOperationIngredient(Block block, Fluid fluid) {
            this.block = block;
            this.fluid = fluid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InWorldToolOperationIngredient that = (InWorldToolOperationIngredient)o;
            return this.block.equals(that.block) && this.fluid.equals(that.fluid);
        }

        public int hashCode() {
            return Objects.hash(this.block, this.fluid);
        }
    }
}

