/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.spatial.SpatialStorageHelper;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import appeng.spatial.TransitionInfo;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpatialStorageCellItem
extends AEBaseItem
implements ISpatialStorageCell {
    private static final String TAG_PLOT_ID = "plot_id";
    private static final String TAG_PLOT_SIZE = "plot_size";
    private final int maxRegion;

    public SpatialStorageCellItem(Item.Properties props, int spatialScale) {
        super(props);
        this.maxRegion = spatialScale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        int plotId = this.getAllocatedPlotId(stack);
        if (plotId == -1) {
            lines.add((ITextComponent)GuiText.Unformatted.text().func_230532_e_().func_240699_a_(TextFormatting.ITALIC));
            lines.add((ITextComponent)GuiText.SpatialCapacity.text(this.maxRegion, this.maxRegion, this.maxRegion));
            return;
        }
        String serialNumber = String.format(Locale.ROOT, "SP-%04d", plotId);
        lines.add((ITextComponent)GuiText.SerialNumber.text(serialNumber));
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(TAG_PLOT_SIZE, 4)) {
            BlockPos size = BlockPos.func_218283_e((long)tag.func_74763_f(TAG_PLOT_SIZE));
            lines.add((ITextComponent)GuiText.StoredSize.text(size.func_177958_n(), size.func_177956_o(), size.func_177952_p()));
        }
    }

    @Override
    public boolean isSpatialStorage(ItemStack is) {
        return true;
    }

    @Override
    public int getMaxStoredDim(ItemStack is) {
        return this.maxRegion;
    }

    @Override
    public int getAllocatedPlotId(ItemStack is) {
        CompoundNBT c = is.func_77978_p();
        if (c != null && c.func_74764_b(TAG_PLOT_ID)) {
            try {
                int plotId = c.func_74762_e(TAG_PLOT_ID);
                if (SpatialStoragePlotManager.INSTANCE.getPlot(plotId) == null) {
                    return -1;
                }
                return plotId;
            }
            catch (Exception e) {
                AELog.warn("Failed to retrieve spatial storage dimension: %s", e);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doSpatialTransition(ItemStack is, ServerWorld w, WorldCoord min, WorldCoord max, int playerId) {
        int targetX = max.x - min.x - 1;
        int targetY = max.y - min.y - 1;
        int targetZ = max.z - min.z - 1;
        int maxSize = this.getMaxStoredDim(is);
        if (targetX > maxSize && targetY > maxSize && targetZ > maxSize) {
            AELog.info("Failing spatial transition because the transfer area (%dx%dx%d) exceeds the cell capacity (%s).", targetX, targetY, targetZ, maxSize);
            return false;
        }
        BlockPos targetSize = new BlockPos(targetX, targetY, targetZ);
        SpatialStoragePlotManager manager = SpatialStoragePlotManager.INSTANCE;
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(this.getAllocatedPlotId(is));
        if (plot != null) {
            if (!plot.getSize().equals((Object)targetSize)) {
                AELog.info("Failing spatial transition because the transfer area (%dx%dx%d) does not match the spatial storage plot's size (%s).", targetX, targetY, targetZ, plot.getSize());
                return false;
            }
        } else {
            plot = manager.allocatePlot(targetSize, playerId);
        }
        TransitionInfo info = new TransitionInfo(w.func_234923_W_().func_240901_a_(), min.getBlockPos(), max.getBlockPos(), Instant.now());
        manager.setLastTransition(plot.getId(), info);
        try {
            ServerWorld cellWorld = manager.getWorld();
            BlockPos offset = plot.getOrigin();
            this.setStoredDimension(is, plot.getId(), plot.getSize());
            SpatialStorageHelper.getInstance().swapRegions(w, min.x + 1, min.y + 1, min.z + 1, cellWorld, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), targetX - 1, targetY - 1, targetZ - 1);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.getAllocatedPlotId(is) == -1) {
                manager.freePlot(plot.getId(), true);
            }
        }
    }

    public void setStoredDimension(ItemStack is, int plotId, BlockPos size) {
        CompoundNBT c = is.func_196082_o();
        c.func_74768_a(TAG_PLOT_ID, plotId);
        c.func_74772_a(TAG_PLOT_SIZE, size.func_218275_a());
    }
}

