/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.container.slot.CraftingMatrixSlot;
import appeng.container.slot.FakeCraftingMatrixSlot;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.JEIRecipePacket;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

class RecipeTransferHandler<T extends Container>
implements IRecipeTransferHandler<T> {
    private final Class<T> containerClass;

    RecipeTransferHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        CompoundNBT recipe = new CompoundNBT();
        int slotIndex = 0;
        for (Map.Entry ingredientEntry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)ingredientEntry.getValue();
            if (!ingredient.isInput()) continue;
            for (Slot slot : ((Container)container).field_75151_b) {
                if (!(slot instanceof CraftingMatrixSlot) && !(slot instanceof FakeCraftingMatrixSlot) || slot.getSlotIndex() != slotIndex) continue;
                ListNBT tags = new ListNBT();
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                ItemStack displayed = (ItemStack)ingredient.getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    list.add(displayed);
                }
                for (ItemStack stack : ingredient.getAllIngredients()) {
                    if (Platform.isRecipePrioritized(stack)) {
                        list.add(0, stack);
                        continue;
                    }
                    list.add(stack);
                }
                for (ItemStack is : list) {
                    CompoundNBT tag = new CompoundNBT();
                    is.func_77955_b(tag);
                    tags.add((Object)tag);
                }
                recipe.func_218657_a("#" + slot.getSlotIndex(), (INBT)tags);
                break;
            }
            ++slotIndex;
        }
        NetworkHandler.instance().sendToServer(new JEIRecipePacket(recipe));
        return null;
    }
}

