/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.FacadeRegistryPlugin;
import appeng.integration.modules.jei.GrinderRecipeCategory;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.JeiRuntimeAdapter;
import appeng.integration.modules.jei.RecipeTransferHandler;
import appeng.items.parts.FacadeItem;
import appeng.recipes.handlers.GrinderRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("appliedenergistics2", "core");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        Optional<Item> maybeFacade = Api.instance().definitions().items().facade().maybeItem();
        maybeFacade.ifPresent(xva$0 -> subtypeRegistry.useNbtForSubtypes(new Item[]{xva$0}));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new GrinderRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CondenserCategory(registry.getJeiHelpers().getGuiHelper()), new InscriberRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(new RecipeTransferHandler<CraftingTermContainer>(CraftingTermContainer.class), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler(new RecipeTransferHandler<PatternTermContainer>(PatternTermContainer.class), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IDefinitions definitions = Api.instance().definitions();
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registration.addRecipes(recipeManager.func_215366_a(GrinderRecipe.TYPE).values(), GrinderRecipeCategory.UID);
        registration.addRecipes(recipeManager.func_215366_a(InscriberRecipe.TYPE).values(), InscriberRecipeCategory.UID);
        registration.addRecipes((Collection)ImmutableList.of((Object)((Object)CondenserOutput.MATTER_BALLS), (Object)((Object)CondenserOutput.SINGULARITY)), CondenserCategory.UID);
        this.registerDescriptions(definitions, registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        IDefinitions definitions = Api.instance().definitions();
        ItemStack grindstone = definitions.blocks().grindstone().stack(1);
        registration.addRecipeCatalyst((Object)grindstone, new ResourceLocation[]{GrinderRecipeCategory.UID});
        ItemStack condenser = definitions.blocks().condenser().stack(1);
        registration.addRecipeCatalyst((Object)condenser, new ResourceLocation[]{CondenserCategory.UID});
        ItemStack inscriber = definitions.blocks().inscriber().stack(1);
        registration.addRecipeCatalyst((Object)inscriber, new ResourceLocation[]{InscriberRecipeCategory.UID});
    }

    private void registerDescriptions(IDefinitions definitions, IRecipeRegistration registry) {
        IMaterials materials = definitions.materials();
        String[] message = AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN) ? new String[]{GuiText.ChargedQuartz.getTranslationKey(), "", GuiText.ChargedQuartzFind.getTranslationKey()} : new String[]{GuiText.ChargedQuartzFind.getTranslationKey()};
        this.addDescription(registry, materials.certusQuartzCrystalCharged(), message);
        if (AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            this.addDescription(registry, materials.logicProcessorPress(), GuiText.inWorldCraftingPresses.getTranslationKey());
            this.addDescription(registry, materials.calcProcessorPress(), GuiText.inWorldCraftingPresses.getTranslationKey());
            this.addDescription(registry, materials.engProcessorPress(), GuiText.inWorldCraftingPresses.getTranslationKey());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_FLUIX)) {
            this.addDescription(registry, materials.fluixCrystal(), GuiText.inWorldFluix.getTranslationKey());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_SINGULARITY)) {
            this.addDescription(registry, materials.qESingularity(), GuiText.inWorldSingularity.getTranslationKey());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            this.addDescription(registry, materials.purifiedCertusQuartzCrystal(), GuiText.inWorldPurificationCertus.getTranslationKey());
            this.addDescription(registry, materials.purifiedNetherQuartzCrystal(), GuiText.inWorldPurificationNether.getTranslationKey());
            this.addDescription(registry, materials.purifiedFluixCrystal(), GuiText.inWorldPurificationFluix.getTranslationKey());
        }
    }

    private void addDescription(IRecipeRegistration registry, IItemDefinition itemDefinition, String ... message) {
        registry.addIngredientInfo((Object)itemDefinition.stack(1), VanillaTypes.ITEM, message);
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        IDefinitions definitions = Api.instance().definitions();
        if (AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_FACADE_CRAFTING)) {
            FacadeItem itemFacade = (FacadeItem)definitions.items().facade().item();
            ItemStack cableAnchor = definitions.parts().cableAnchor().stack(1);
            registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new FacadeRegistryPlugin(itemFacade, cableAnchor));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIFacade.setInstance(new JeiRuntimeAdapter(jeiRuntime));
        this.hideDebugTools(jeiRuntime);
    }

    private void hideDebugTools(IJeiRuntime jeiRuntime) {
        ArrayList<Object> toRemove = new ArrayList<Object>();
        toRemove.add(Api.INSTANCE.definitions().items().dummyFluidItem().maybeStack(1).orElse(null));
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.UNSUPPORTED_DEVELOPER_TOOLS)) {
            toRemove.add(Api.INSTANCE.definitions().blocks().cubeGenerator().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().chunkLoader().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().energyGenerator().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().itemGen().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().phantomNode().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolDebugCard().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolEraser().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolMeteoritePlacer().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolReplicatorCard().maybeStack(1).orElse(null));
        }
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, toRemove);
    }
}

