/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.Api;
import appeng.recipes.handlers.GrinderOptionalResult;
import appeng.recipes.handlers.GrinderRecipe;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

class GrinderRecipeCategory
implements IRecipeCategory<GrinderRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("appliedenergistics2", "grinder");
    private final String localizedName = I18n.func_135052_a((String)"block.appliedenergistics2.grindstone", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    public GrinderRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("appliedenergistics2", "textures/guis/grinder.png");
        this.background = guiHelper.createDrawable(location, 11, 16, 154, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)Api.INSTANCE.definitions().blocks().grindstone().stack(1));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, GrinderRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 0);
        itemStacks.init(1, false, 100, 46);
        itemStacks.init(2, false, 118, 46);
        itemStacks.init(3, false, 136, 46);
        itemStacks.set(ingredients);
    }

    public Class<? extends GrinderRecipe> getRecipeClass() {
        return GrinderRecipe.class;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(GrinderRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getIngredient()));
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(3);
        outputs.add(recipe.func_77571_b());
        for (GrinderOptionalResult optionalResult : recipe.getOptionalResults()) {
            outputs.add(optionalResult.getResult());
        }
        ingredients.setOutputs(VanillaTypes.ITEM, outputs);
    }
}

