/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.core.Api;
import appeng.fluids.container.FluidFormationPlaneContainer;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.AbstractFormationPlanePart;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import appeng.util.Platform;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidFormationPlanePart
extends AbstractFormationPlanePart<IAEFluidStack>
implements IAEFluidInventory {
    private static final PlaneModels MODELS = new PlaneModels("part/fluid_formation_plane", "part/fluid_formation_plane_on");
    private final MEInventoryHandler<IAEFluidStack> myHandler = new MEInventoryHandler<IAEFluidStack>(this, Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
    private final AEFluidInventory config = new AEFluidInventory(this, 63);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FluidFormationPlanePart(ItemStack is) {
        super(is);
        this.updateHandler();
    }

    @Override
    protected void updateHandler() {
        this.myHandler.setBaseAccess(AccessRestriction.WRITE);
        this.myHandler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.myHandler.setPriority(this.getPriority());
        IItemList<IAEFluidStack> priorityList = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.config.getSlots() && x < slotsToUse; ++x) {
            IAEFluidStack is = this.config.getFluidInSlot(x);
            if (is == null) continue;
            priorityList.add(is);
        }
        this.myHandler.setPartitionList(new PrecisePriorityList(priorityList));
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        if (this.blocked || input == null || input.getStackSize() < 1000L) {
            return input;
        }
        TileEntity te = this.getHost().getTile();
        World w = te.func_145831_w();
        AEPartLocation side = this.getSide();
        BlockPos pos = te.func_174877_v().func_177972_a(side.getFacing());
        BlockState state = w.func_180495_p(pos);
        if (this.canReplace(w, state, pos)) {
            if (type == Actionable.MODULATE) {
                FluidStack fs = input.getFluidStack();
                fs.setAmount(1000);
                FluidTank tank = new FluidTank(1000);
                tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)w));
                if (!FluidUtil.tryPlaceFluid((PlayerEntity)fakePlayer, (World)w, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (IFluidHandler)tank, (FluidStack)fs)) {
                    return input;
                }
            }
            IAEFluidStack ret = input.copy();
            ret.setStackSize(input.getStackSize() - 1000L);
            return ret.getStackSize() == 0L ? null : ret;
        }
        this.blocked = true;
        return input;
    }

    private boolean canReplace(World w, BlockState state, BlockPos pos) {
        return state.func_185904_a().func_76222_j() && w.func_204610_c(pos).func_206888_e() && !state.func_185904_a().func_76224_d();
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        if (inv == this.config) {
            this.updateHandler();
        }
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        super.readFromNBT(data);
        this.config.readFromNBT(data, "config");
        this.updateHandler();
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        super.writeToNBT(data);
        this.config.writeToNBT(data, "config");
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.stateChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        this.stateChanged();
    }

    @Override
    public boolean onPartActivate(PlayerEntity player, Hand hand, Vector3d pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(FluidFormationPlaneContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive() && channel == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            ArrayList<IMEInventoryHandler> handler = new ArrayList<IMEInventoryHandler>(1);
            handler.add(this.myHandler);
            return handler;
        }
        return Collections.emptyList();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new PlaneModelData(this.getConnections());
    }

    public IAEFluidTank getConfig() {
        return this.config;
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return Api.instance().definitions().parts().fluidFormationnPlane().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public ContainerType<?> getContainerType() {
        return FluidFormationPlaneContainer.TYPE;
    }
}

