/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEFluidInventoryUpdatePacket;
import appeng.core.sync.packets.TargetFluidStackPacket;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.io.IOException;
import java.nio.BufferOverflowException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidTerminalContainer
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    public static ContainerType<FluidTerminalContainer> TYPE;
    private static final ContainerHelper<FluidTerminalContainer, ITerminalHost> helper;
    private final IConfigManager clientCM;
    private final IMEMonitor<IAEFluidStack> monitor;
    private final IItemList<IAEFluidStack> fluids = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    @GuiSync(value=99)
    public boolean hasPower = false;
    private ITerminalHost terminal;
    private IConfigManager serverCM;
    private IConfigManagerHost gui;
    private IGridNode networkNode;
    private IAEFluidStack clientRequestedTargetFluid = null;

    public static FluidTerminalContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public FluidTerminalContainer(int id, PlayerInventory ip, ITerminalHost terminal) {
        super(TYPE, id, ip, terminal);
        this.terminal = terminal;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        if (Platform.isServer()) {
            this.serverCM = terminal.getConfigManager();
            this.monitor = terminal.getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            if (this.monitor != null) {
                IGridNode node;
                this.monitor.addListener(this, null);
                if (terminal instanceof IEnergySource) {
                    this.setPowerSource((IEnergySource)((Object)terminal));
                } else if ((terminal instanceof IGridHost || terminal instanceof IActionHost) && (node = terminal instanceof IGridHost ? ((IGridHost)((Object)terminal)).getGridNode(AEPartLocation.INTERNAL) : (terminal instanceof IActionHost ? ((IActionHost)((Object)terminal)).getActionableNode() : null)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource(new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            }
        } else {
            this.monitor = null;
        }
        this.bindPlayerInventory(ip, 0, 140);
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add(is);
        }
    }

    @Override
    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.queueInventory(c);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.queueInventory(listener);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    private void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof PlayerEntity && this.monitor != null) {
            try {
                MEFluidInventoryUpdatePacket piu = new MEFluidInventoryUpdatePacket();
                IItemList<IAEFluidStack> monitorCache = this.monitor.getStorageList();
                for (IAEFluidStack send : monitorCache) {
                    try {
                        piu.appendFluid(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance().sendTo(piu, (ServerPlayerEntity)c);
                        piu = new MEFluidInventoryUpdatePacket();
                        piu.appendFluid(send);
                    }
                }
                NetworkHandler.instance().sendTo(piu, (ServerPlayerEntity)c);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void setTargetStack(IAEFluidStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetFluid == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetFluid != null && stack.getFluidStack().isFluidEqual(this.clientRequestedTargetFluid.getFluidStack())) {
                return;
            }
            NetworkHandler.instance().sendToServer(new TargetFluidStackPacket((AEFluidStack)stack));
        }
        this.clientRequestedTargetFluid = stack == null ? null : stack.copy();
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.monitor != this.terminal.getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class))) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum<?> sideRemote;
                Enum<?> sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (IContainerListener crafter : this.field_75149_d) {
                    if (!(crafter instanceof ServerPlayerEntity)) continue;
                    NetworkHandler.instance().sendTo(new ConfigValuePacket(set.name(), sideLocal.name()), (ServerPlayerEntity)crafter);
                }
            }
            if (!this.fluids.isEmpty()) {
                try {
                    IItemList<IAEFluidStack> monitorCache = this.monitor.getStorageList();
                    MEFluidInventoryUpdatePacket piu = new MEFluidInventoryUpdatePacket();
                    for (IAEFluidStack is : this.fluids) {
                        IAEFluidStack send = monitorCache.findPrecise(is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendFluid(is);
                            continue;
                        }
                        piu.appendFluid(send);
                    }
                    if (!piu.isEmpty()) {
                        this.fluids.resetStatus();
                        for (IAEFluidStack c : this.field_75149_d) {
                            if (!(c instanceof PlayerEntity)) continue;
                            NetworkHandler.instance().sendTo(piu, (ServerPlayerEntity)c);
                        }
                    }
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
            }
            this.updatePowerStatus();
            super.func_75142_b();
        }
    }

    @Override
    public void doAction(ServerPlayerEntity player, InventoryAction action, int slot, long id) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            super.doAction(player, action, slot, id);
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        if (held.func_190916_E() != 1) {
            return;
        }
        LazyOptional fhOpt = FluidUtil.getFluidHandler((ItemStack)held);
        if (!fhOpt.isPresent()) {
            return;
        }
        IFluidHandlerItem fh = (IFluidHandlerItem)fhOpt.orElse(null);
        if (action == InventoryAction.FILL_ITEM && this.clientRequestedTargetFluid != null) {
            IAEFluidStack stack = this.clientRequestedTargetFluid.copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = fh.fill(stack.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
            stack.setStackSize(amountAllowed);
            IAEFluidStack canPull = Platform.poweredExtraction(this.getPowerSource(), this.monitor, stack, this.getActionSource(), Actionable.SIMULATE);
            if (canPull == null || canPull.getStackSize() < 1L) {
                return;
            }
            int canFill = fh.fill(canPull.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
            if (canFill == 0) {
                return;
            }
            stack.setStackSize(canFill);
            IAEFluidStack pulled = Platform.poweredExtraction(this.getPowerSource(), this.monitor, stack, this.getActionSource());
            if (pulled == null || pulled.getStackSize() < 1L) {
                AELog.error("Unable to pull fluid out of the ME system even though the simulation said yes ", new Object[0]);
                return;
            }
            int used = fh.fill(pulled.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
            if (used != canFill) {
                AELog.error("Fluid item [%s] reported a different possible amount than it actually accepted.", held.func_200301_q());
            }
            player.field_71071_by.func_70437_b(fh.getContainer());
            this.updateHeld(player);
        } else if (action == InventoryAction.EMPTY_ITEM) {
            FluidStack extract = fh.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (extract.isEmpty() || extract.getAmount() < 1) {
                return;
            }
            IAEFluidStack notStorable = Platform.poweredInsert(this.getPowerSource(), this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource(), Actionable.SIMULATE);
            if (notStorable != null && notStorable.getStackSize() > 0L) {
                int toStore = (int)((long)extract.getAmount() - notStorable.getStackSize());
                FluidStack storable = fh.drain(toStore, IFluidHandler.FluidAction.SIMULATE);
                if (storable.isEmpty() || storable.getAmount() == 0) {
                    return;
                }
                extract.setAmount(storable.getAmount());
            }
            FluidStack drained = fh.drain(extract, IFluidHandler.FluidAction.EXECUTE);
            extract.setAmount(drained.getAmount());
            IAEFluidStack notInserted = Platform.poweredInsert(this.getPowerSource(), this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource());
            if (notInserted != null && notInserted.getStackSize() > 0L) {
                AELog.error("Fluid item [%s] reported a different possible amount to drain than it actually provided.", held.func_200301_q());
            }
            player.field_71071_by.func_70437_b(fh.getContainer());
            this.updateHeld(player);
        }
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    static {
        helper = new ContainerHelper<FluidTerminalContainer, ITerminalHost>(FluidTerminalContainer::new, ITerminalHost.class, SecurityPermissions.BUILD);
    }
}

