/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.widgets.CustomSlotWidget;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FluidSlotPacket;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidSlotWidget
extends CustomSlotWidget {
    private final IAEFluidTank fluids;
    private final int slot;

    public FluidSlotWidget(IAEFluidTank fluids, int slot, int id, int x, int y) {
        super(id, x, y);
        this.fluids = fluids;
        this.slot = slot;
    }

    @Override
    public void drawContent(MatrixStack matrixStack, Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        IAEFluidStack fs = this.getFluidStack();
        if (fs != null) {
            RenderSystem.disableBlend();
            Fluid fluid = fs.getFluid();
            FluidAttributes attributes = fluid.getAttributes();
            mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.func_228015_a_(AtlasTexture.field_110575_b).apply(attributes.getStillTexture(fs.getFluidStack()));
            float red = (float)(attributes.getColor() >> 16 & 0xFF) / 255.0f;
            float green = (float)(attributes.getColor() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(attributes.getColor() & 0xFF) / 255.0f;
            RenderSystem.color3f((float)red, (float)green, (float)blue);
            FluidSlotWidget.func_238470_a_((MatrixStack)matrixStack, (int)this.getTooltipAreaX(), (int)this.getTooltipAreaY(), (int)this.func_230927_p_(), (int)this.getTooltipAreaWidth(), (int)this.getTooltipAreaHeight(), (TextureAtlasSprite)sprite);
        }
    }

    @Override
    public boolean canClick(PlayerEntity player) {
        ItemStack mouseStack = player.field_71071_by.func_70445_o();
        return mouseStack.func_190926_b() || mouseStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    @Override
    public void slotClicked(ItemStack clickStack, int mouseButton) {
        if (clickStack.func_190926_b() || mouseButton == 1) {
            this.setFluidStack(null);
        } else if (mouseButton == 0) {
            Optional fluidOpt = FluidUtil.getFluidContained((ItemStack)clickStack);
            fluidOpt.ifPresent(fluid -> this.setFluidStack(AEFluidStack.fromFluidStack(fluid)));
        }
    }

    @Override
    public ITextComponent getTooltipMessage() {
        IAEFluidStack fluid = this.getFluidStack();
        if (fluid != null) {
            return new TranslationTextComponent(fluid.getFluidStack().getTranslationKey());
        }
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public IAEFluidStack getFluidStack() {
        return this.fluids.getFluidInSlot(this.slot);
    }

    public void setFluidStack(IAEFluidStack stack) {
        this.fluids.setFluidInSlot(this.slot, stack);
        NetworkHandler.instance().sendToServer(new FluidSlotPacket(Collections.singletonMap(this.getId(), this.getFluidStack())));
    }
}

