/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.items.AEBaseItem;
import appeng.util.Platform;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoritePlacer;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.debug.MeteoriteSpawner;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public class MeteoritePlacerItem
extends AEBaseItem {
    private static final String MODE_TAG = "mode";

    public MeteoritePlacerItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.func_201670_d()) {
            return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
        }
        if (player.func_225608_bj_()) {
            ItemStack itemStack = player.func_184586_b(hand);
            CompoundNBT tag = itemStack.func_196082_o();
            if (tag.func_74764_b(MODE_TAG)) {
                byte mode = tag.func_74771_c(MODE_TAG);
                tag.func_74774_a(MODE_TAG, (byte)((mode + 1) % CraterType.values().length));
            } else {
                tag.func_74774_a(MODE_TAG, (byte)CraterType.NORMAL.ordinal());
            }
            CraterType craterType = CraterType.values()[tag.func_74771_c(MODE_TAG)];
            player.func_145747_a((ITextComponent)new StringTextComponent(craterType.name()), Util.field_240973_b_);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.PASS;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)context.func_195999_j();
        ServerWorld world = (ServerWorld)context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (player == null) {
            return ActionResultType.PASS;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_74764_b(MODE_TAG)) {
            tag.func_74774_a(MODE_TAG, (byte)CraterType.NORMAL.ordinal());
        }
        float coreRadius = Platform.getRandomFloat() * 6.0f + 2.0f;
        boolean pureCrater = Platform.getRandomFloat() > 0.5f;
        MeteoriteSpawner spawner = new MeteoriteSpawner();
        CraterType craterType = CraterType.values()[tag.func_74771_c(MODE_TAG)];
        PlacedMeteoriteSettings spawned = spawner.trySpawnMeteoriteAtSuitableHeight((IWorldReader)world, pos, coreRadius, craterType, pureCrater, false);
        if (spawned == null) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Un-suitable Location."), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        int range = (int)Math.ceil((coreRadius * 2.0f + 5.0f) * 5.0f);
        MutableBoundingBox boundingBox = new MutableBoundingBox(pos.func_177958_n() - range, pos.func_177956_o(), pos.func_177952_p() - range, pos.func_177958_n() + range, pos.func_177956_o(), pos.func_177952_p() + range);
        MeteoritePlacer placer = new MeteoritePlacer((IWorld)world, spawned, boundingBox);
        placer.place();
        player.func_145747_a((ITextComponent)new StringTextComponent("Spawned at y=" + spawned.getPos().func_177956_o() + " range=" + range + " biomeCategory=" + world.func_226691_t_(pos).func_201856_r()), Util.field_240973_b_);
        ChunkPos.func_222243_a((ChunkPos)new ChunkPos(spawned.getPos()), (int)1).forEach(cp -> {
            Chunk c = world.func_212866_a_(cp.field_77276_a, cp.field_77275_b);
            player.field_71135_a.func_147359_a((IPacket)new SChunkDataPacket(c, 65535));
        });
        return ActionResultType.SUCCESS;
    }
}

