/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class TargetFluidStackPacket
extends BasePacket {
    private AEFluidStack stack;

    public TargetFluidStackPacket(PacketBuffer stream) {
        try {
            this.stack = stream.readableBytes() > 0 ? (AEFluidStack)AEFluidStack.fromPacket(stream) : null;
        }
        catch (Exception ex) {
            AELog.debug(ex);
            this.stack = null;
        }
    }

    public TargetFluidStackPacket(AEFluidStack stack) {
        this.stack = stack;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (stack != null) {
            try {
                stack.writeToPacket(data);
            }
            catch (Exception ex) {
                AELog.debug(ex);
            }
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        if (player.field_71070_bA instanceof FluidTerminalContainer) {
            ((FluidTerminalContainer)player.field_71070_bA).setTargetStack(this.stack);
        }
    }
}

