/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.fluids.client.gui.FluidTerminalScreen;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;

public class MEFluidInventoryUpdatePacket
extends BasePacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    private static final int OPERATION_BYTE_LIMIT = 2048;
    @Nullable
    private final List<IAEFluidStack> list;
    private final byte ref;
    @Nullable
    private final PacketBuffer data;
    private int writtenBytes = 0;
    private boolean empty = true;

    public MEFluidInventoryUpdatePacket(PacketBuffer stream) {
        this.data = null;
        this.list = new LinkedList<IAEFluidStack>();
        this.ref = stream.readByte();
        while (stream.readableBytes() > 0) {
            this.list.add(AEFluidStack.fromPacket(stream));
        }
        this.empty = this.list.isEmpty();
    }

    public MEFluidInventoryUpdatePacket() throws IOException {
        this(0);
    }

    public MEFluidInventoryUpdatePacket(byte ref) throws IOException {
        this.ref = ref;
        this.data = new PacketBuffer(Unpooled.buffer((int)2048));
        this.data.writeInt(this.getPacketID());
        this.data.writeByte((int)this.ref);
        this.list = null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        Screen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof FluidTerminalScreen) {
            ((FluidTerminalScreen)gs).postUpdate(this.list);
        }
    }

    @Override
    @Nullable
    public IPacket<?> toPacket(NetworkDirection direction) {
        this.configureWrite(this.data);
        return super.toPacket(direction);
    }

    public void appendFluid(IAEFluidStack fs) throws IOException, BufferOverflowException {
        PacketBuffer tmp = new PacketBuffer(Unpooled.buffer((int)2048));
        fs.writeToPacket(tmp);
        if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
            throw new BufferOverflowException();
        }
        this.writtenBytes += tmp.readableBytes();
        this.data.writeBytes(tmp.array(), 0, tmp.readableBytes());
        this.empty = false;
    }

    public int getLength() {
        return this.data.readableBytes();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

