/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.tile.crafting.AssemblerAnimationStatus;
import appeng.tile.crafting.MolecularAssemblerTileEntity;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AssemblerAnimationPacket
extends BasePacket {
    private final BlockPos pos;
    public final byte rate;
    public final IAEItemStack is;

    public AssemblerAnimationPacket(PacketBuffer stream) {
        this.pos = stream.func_179259_c();
        this.rate = stream.readByte();
        this.is = AEItemStack.fromPacket(stream);
    }

    public AssemblerAnimationPacket(BlockPos pos, byte rate, IAEItemStack is) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.pos = pos;
        data.func_179255_a(this.pos);
        this.rate = rate;
        data.writeByte((int)this.rate);
        is.writeToPacket(data);
        this.is = is;
        this.configureWrite(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        TileEntity te = player.func_130014_f_().func_175625_s(this.pos);
        if (te instanceof MolecularAssemblerTileEntity) {
            MolecularAssemblerTileEntity ma = (MolecularAssemblerTileEntity)te;
            ma.setAnimationStatus(new AssemblerAnimationStatus(this.rate, this.is.asItemStackRepresentation()));
        }
    }
}

