/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IWorldGen;
import java.util.HashSet;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public final class WorldGenRegistry
implements IWorldGen {
    public static final WorldGenRegistry INSTANCE = new WorldGenRegistry();
    private final TypeSet[] types = new TypeSet[IWorldGen.WorldGenType.values().length];

    private WorldGenRegistry() {
        for (IWorldGen.WorldGenType type : IWorldGen.WorldGenType.values()) {
            this.types[type.ordinal()] = new TypeSet();
        }
    }

    @Override
    public void enableWorldGenForDimension(IWorldGen.WorldGenType type, ResourceLocation dimensionID) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        this.types[type.ordinal()].enabledDimensions.add(dimensionID);
    }

    @Override
    public void disableWorldGenForDimension(IWorldGen.WorldGenType type, ResourceLocation dimensionID) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        this.types[type.ordinal()].badDimensions.add(dimensionID);
    }

    @Override
    public boolean isWorldGenEnabled(IWorldGen.WorldGenType type, ServerWorld w) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        if (w == null) {
            throw new IllegalArgumentException("Bad Provider Passed");
        }
        ResourceLocation id = w.func_234923_W_().func_240901_a_();
        boolean isBadDimension = this.types[type.ordinal()].badDimensions.contains(id);
        boolean isGoodDimension = this.types[type.ordinal()].enabledDimensions.contains(id);
        if (isBadDimension) {
            return false;
        }
        return isGoodDimension || type != IWorldGen.WorldGenType.METEORITES;
    }

    private static class TypeSet {
        final HashSet<ResourceLocation> badDimensions = new HashSet();
        final HashSet<ResourceLocation> enabledDimensions = new HashSet();

        private TypeSet() {
        }
    }
}

