/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.api.features.AEFeature;
import appeng.core.features.IStackSrc;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class DamagedItemDefinition
implements IItemDefinition {
    private final String identifier;
    private final IStackSrc source;

    public DamagedItemDefinition(@Nonnull String identifier, @Nonnull IStackSrc source) {
        this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
        this.source = (IStackSrc)Preconditions.checkNotNull((Object)source);
    }

    @Override
    public Item item() {
        return this.source.getItem();
    }

    @Override
    public ItemStack stack(int stackSize) {
        return this.source.stack(stackSize);
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Optional<Item> maybeItem() {
        return Optional.of(this.source.getItem());
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        return Optional.of(this.source.stack(stackSize));
    }

    @Override
    public Set<AEFeature> features() {
        return Collections.emptySet();
    }

    @Override
    public boolean isSameAs(ItemStack comparableStack) {
        if (comparableStack.func_190926_b()) {
            return false;
        }
        return comparableStack.func_77973_b() == this.source.getItem();
    }
}

