/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.helpers.CraftingPatternDetails;
import appeng.items.misc.EncodedPatternItem;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ApiCrafting
implements ICraftingHelper {
    private final IItemDefinition encodedPattern;

    public ApiCrafting(ApiDefinitions definitions) {
        this.encodedPattern = definitions.items().encodedPattern();
    }

    @Override
    public boolean isEncodedPattern(@Nullable IAEItemStack item) {
        return item != null && item.getItem() instanceof EncodedPatternItem;
    }

    @Override
    public boolean isEncodedPattern(ItemStack item) {
        return !item.func_190926_b() && item.func_77973_b() instanceof EncodedPatternItem;
    }

    @Override
    public ItemStack encodeCraftingPattern(@Nullable ItemStack stack, ICraftingRecipe recipe, ItemStack[] in, ItemStack out, boolean allowSubstitutes) {
        if (stack == null) {
            stack = this.encodedPattern.stack(1);
        } else {
            Preconditions.checkArgument((boolean)this.isEncodedPattern(stack));
        }
        EncodedPatternItem.encodeCraftingPattern(stack, in, new ItemStack[]{out}, recipe.func_199560_c(), allowSubstitutes);
        return stack;
    }

    @Override
    public ItemStack encodeProcessingPattern(@Nullable ItemStack stack, ItemStack[] in, ItemStack[] out) {
        if (stack == null) {
            stack = this.encodedPattern.stack(1);
        } else {
            Preconditions.checkArgument((boolean)this.isEncodedPattern(stack));
        }
        EncodedPatternItem.encodeProcessingPattern(stack, in, out);
        return stack;
    }

    @Override
    public ICraftingPatternDetails decodePattern(ItemStack is, World world, boolean autoRecovery) {
        IRecipe recipe;
        if (is == null || world == null) {
            return null;
        }
        EncodedPatternItem patternItem = ApiCrafting.getPatternItem(is);
        if (patternItem == null || !patternItem.isEncodedPattern(is)) {
            return null;
        }
        ResourceLocation recipeId = patternItem.getCraftingRecipeId(is);
        if (!(recipeId == null || (recipe = (IRecipe)world.func_199532_z().func_215366_a(IRecipeType.field_222149_a).get(recipeId)) instanceof ICraftingRecipe || autoRecovery && this.attemptRecovery(patternItem, is, world))) {
            return null;
        }
        IAEItemStack ais = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(is);
        try {
            return new CraftingPatternDetails(ais, world);
        }
        catch (IllegalStateException e) {
            AELog.warn("Could not decode an invalid pattern %s: %s", is, e);
            return null;
        }
    }

    private boolean attemptRecovery(EncodedPatternItem patternItem, ItemStack itemStack, World world) {
        RecipeManager recipeManager = world.func_199532_z();
        List<IAEItemStack> ingredients = patternItem.getIngredients(itemStack);
        List<IAEItemStack> products = patternItem.getProducts(itemStack);
        if (ingredients.size() < 9 || products.size() < 1) {
            return false;
        }
        ResourceLocation currentRecipeId = patternItem.getCraftingRecipeId(itemStack);
        CraftingInventory testInventory = new CraftingInventory((Container)new ContainerNull(), 3, 3);
        for (int x = 0; x < 9; ++x) {
            IAEItemStack ais2 = ingredients.get(x);
            ItemStack gs = ais2 != null ? ais2.createItemStack() : ItemStack.field_190927_a;
            testInventory.func_70299_a(x, gs);
        }
        ICraftingRecipe potentialRecipe = recipeManager.func_215371_a(IRecipeType.field_222149_a, (IInventory)testInventory, world).orElse(null);
        if (potentialRecipe != null && products.get(0).isSameType(potentialRecipe.func_77572_b((IInventory)testInventory))) {
            AELog.debug("Re-Encoding pattern from %s -> %s", currentRecipeId, potentialRecipe.func_199560_c());
            ItemStack[] in = (ItemStack[])ingredients.stream().map(ais -> ais != null ? ais.createItemStack() : ItemStack.field_190927_a).toArray(ItemStack[]::new);
            ItemStack out = products.get(0).createItemStack();
            this.encodeCraftingPattern(itemStack, potentialRecipe, in, out, patternItem.allowsSubstitution(itemStack));
        }
        AELog.debug("Failed to recover encoded crafting pattern for recipe %s", currentRecipeId);
        return false;
    }

    private static EncodedPatternItem getPatternItem(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof EncodedPatternItem) {
            return (EncodedPatternItem)itemStack.func_77973_b();
        }
        return null;
    }
}

