/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.mixins.feature.ConfiguredFeaturesAccessor;
import appeng.mixins.structure.ConfiguredStructureFeaturesAccessor;
import appeng.mixins.structure.StructureFeatureAccessor;
import appeng.spatial.SpatialStorageChunkGenerator;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.worldgen.BiomeModifier;
import appeng.worldgen.ChargedQuartzOreConfig;
import appeng.worldgen.ChargedQuartzOreFeature;
import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;

public final class AppEngBootstrap {
    private static boolean initialized;
    private static ConfiguredFeature<?, ?> quartzOreFeature;
    private static ConfiguredFeature<?, ?> chargedQuartzOreFeature;

    private AppEngBootstrap() {
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        AppEngBootstrap.registerStructures();
        quartzOreFeature = AppEngBootstrap.registerQuartzOreFeature();
        chargedQuartzOreFeature = AppEngBootstrap.registerChargedQuartzOreFeature();
        AppEngBootstrap.registerDimension();
    }

    public static synchronized void enhanceBiomes() {
        WorldGenRegistries.field_243657_i.forEach(b -> {
            AppEngBootstrap.addMeteoriteWorldGen(b);
            AppEngBootstrap.addQuartzWorldGen(b, quartzOreFeature, chargedQuartzOreFeature);
        });
    }

    private static void registerStructures() {
        MeteoriteStructurePiece.register();
        StructureFeatureAccessor.register(MeteoriteStructure.ID.toString(), MeteoriteStructure.INSTANCE, GenerationStage.Decoration.TOP_LAYER_MODIFICATION);
        ConfiguredStructureFeaturesAccessor.register(MeteoriteStructure.ID.toString(), MeteoriteStructure.CONFIGURED_INSTANCE);
    }

    private static void addMeteoriteWorldGen(Biome b) {
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            return;
        }
        if (b.func_201856_r() == Biome.Category.THEEND || b.func_201856_r() == Biome.Category.NETHER) {
            return;
        }
        BiomeModifier modifier = new BiomeModifier(b);
        modifier.addStructureFeature(MeteoriteStructure.CONFIGURED_INSTANCE);
    }

    private static void addQuartzWorldGen(Biome b, ConfiguredFeature<?, ?> quartzOre, ConfiguredFeature<?, ?> chargedQuartz) {
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN)) {
            return;
        }
        BiomeModifier modifier = new BiomeModifier(b);
        modifier.addFeature(GenerationStage.Decoration.UNDERGROUND_ORES, quartzOre);
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CHARGED_CERTUS_ORE)) {
            modifier.addFeature(GenerationStage.Decoration.UNDERGROUND_DECORATION, chargedQuartz);
        }
    }

    private static ConfiguredFeature<?, ?> registerQuartzOreFeature() {
        BlockState quartzOreState = Api.instance().definitions().blocks().quartzOre().block().func_176223_P();
        return ConfiguredFeaturesAccessor.register(AppEng.makeId("quartz_ore").toString(), (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, quartzOreState, AEConfig.instance().getQuartzOresPerCluster())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(12, 12, 72))).func_242728_a()).func_242731_b(AEConfig.instance().getQuartzOresClusterAmount()));
    }

    private static ConfiguredFeature<?, ?> registerChargedQuartzOreFeature() {
        Registry.func_218322_a((Registry)Registry.field_218379_q, (ResourceLocation)AppEng.makeId("charged_quartz_ore"), (Object)((Object)ChargedQuartzOreFeature.INSTANCE));
        BlockState quartzOreState = Api.instance().definitions().blocks().quartzOre().block().func_176223_P();
        BlockState chargedQuartzOreState = Api.instance().definitions().blocks().quartzOreCharged().block().func_176223_P();
        return ConfiguredFeaturesAccessor.register(AppEng.makeId("charged_quartz_ore").toString(), ChargedQuartzOreFeature.INSTANCE.func_225566_b_(new ChargedQuartzOreConfig(quartzOreState, chargedQuartzOreState, AEConfig.instance().getSpawnChargedChance())).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_)));
    }

    private static void registerDimension() {
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)SpatialStorageDimensionIds.CHUNK_GENERATOR_ID, SpatialStorageChunkGenerator.CODEC);
    }
}

