/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.bootstrap.components.IInitComponent;
import appeng.bootstrap.components.IPostInitComponent;
import appeng.capabilities.Capabilities;
import appeng.client.ClientHelper;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AddonLoader;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.AppEngBootstrap;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.FacadeItemGroup;
import appeng.core.Registration;
import appeng.core.stats.AdvancementTriggers;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.worlddata.WorldData;
import appeng.entity.ChargedQuartzEntity;
import appeng.entity.GrowingCrystalEntity;
import appeng.entity.SingularityEntity;
import appeng.entity.TinyTNTPrimedEntity;
import appeng.entity.TinyTNTPrimedRenderer;
import appeng.hooks.TickHandler;
import appeng.integration.Integrations;
import appeng.parts.PartPlacement;
import appeng.server.ServerHelper;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="appliedenergistics2")
public final class AppEng {
    public static CommonHelper proxy;
    public static final String MOD_ID = "appliedenergistics2";
    public static final String MOD_NAME = "Applied Energistics 2";
    private static AppEng INSTANCE;
    private final Registration registration;

    public static ResourceLocation makeId(String id) {
        return new ResourceLocation(MOD_ID, id);
    }

    public AppEng() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, AEConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AEConfig.COMMON_SPEC);
        proxy = (CommonHelper)DistExecutor.unsafeRunForDist(() -> ClientHelper::new, () -> ServerHelper::new);
        CreativeTab.init();
        new FacadeItemGroup();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registration = new Registration();
        modEventBus.addListener(this::bootstrap);
        modEventBus.addGenericListener(Block.class, this.registration::registerBlocks);
        modEventBus.addGenericListener(Item.class, this.registration::registerItems);
        modEventBus.addGenericListener(EntityType.class, this.registration::registerEntities);
        modEventBus.addGenericListener(ParticleType.class, this.registration::registerParticleTypes);
        modEventBus.addGenericListener(TileEntityType.class, this.registration::registerTileEntities);
        modEventBus.addGenericListener(ContainerType.class, this.registration::registerContainerTypes);
        modEventBus.addGenericListener(IRecipeSerializer.class, this.registration::registerRecipeSerializers);
        modEventBus.addListener(Integrations::enqueueIMC);
        modEventBus.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this.registration::registerClientEvents);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::clientSetup));
        TickHandler.setup(MinecraftForge.EVENT_BUS);
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        MinecraftForge.EVENT_BUS.addListener(this.registration::registerCommands);
        MinecraftForge.EVENT_BUS.register((Object)new PartPlacement());
    }

    private void bootstrap(RegistryEvent.NewRegistry e) {
        AppEngBootstrap.initialize();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(AppEngBootstrap::enhanceBiomes);
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IInitComponent.class).forEachRemaining(IInitComponent::initialize);
        definitions.getRegistry().getBootstrapComponents(IPostInitComponent.class).forEachRemaining(IPostInitComponent::postInitialize);
        Capabilities.register();
        Registration.setupInternalRegistries();
        Registration.postInit();
        this.registerNetworkHandler();
        AddonLoader.loadAddons(Api.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        ((ClientHelper)proxy).clientInit();
        RenderingRegistry.registerEntityRenderingHandler(TinyTNTPrimedEntity.TYPE, TinyTNTPrimedRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SingularityEntity.TYPE, m -> new ItemRenderer(m, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(GrowingCrystalEntity.TYPE, m -> new ItemRenderer(m, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ChargedQuartzEntity.TYPE, m -> new ItemRenderer(m, Minecraft.func_71410_x().func_175599_af()));
    }

    @Nonnull
    public static AppEng instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException();
        }
        return INSTANCE;
    }

    public AdvancementTriggers getAdvancementTriggers() {
        return Registration.advancementTriggers;
    }

    private void startService(String serviceName, Thread thread) {
        thread.setName(serviceName);
        thread.setPriority(1);
        AELog.info("Starting " + serviceName, new Object[0]);
        thread.start();
    }

    private void registerNetworkHandler() {
        Stopwatch start = Stopwatch.createStarted();
        AELog.info("Post Initialization ( started )", new Object[0]);
        proxy.postInit();
        AEConfig.instance().save();
        NetworkHandler.init(new ResourceLocation(MOD_ID, "main"));
        AELog.info("Post Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    private void onServerAboutToStart(FMLServerAboutToStartEvent evt) {
        WorldData.onServerStarting(evt.getServer());
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        WorldData.instance().onServerStopping();
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        WorldData.instance().onServerStoppped();
        TickHandler.instance().shutdown();
    }
}

