/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.container.slot.FakeSlot;
import appeng.container.slot.IOptionalSlot;
import appeng.container.slot.IOptionalSlotHost;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class OptionalFakeSlot
extends FakeSlot
implements IOptionalSlot {
    private final int srcX;
    private final int srcY;
    private final int groupNum;
    private final IOptionalSlotHost host;
    private boolean renderDisabled = true;

    public OptionalFakeSlot(IItemHandler inv, IOptionalSlotHost containerBus, int invSlot, int x, int y, int offX, int offY, int groupNum) {
        super(inv, invSlot, x + offX * 18, y + offY * 18);
        this.srcX = x;
        this.srcY = y;
        this.groupNum = groupNum;
        this.host = containerBus;
    }

    @Override
    @Nonnull
    public ItemStack func_75211_c() {
        if (!this.isSlotEnabled() && !this.getDisplayStack().func_190926_b()) {
            this.clearStack();
        }
        return super.func_75211_c();
    }

    @Override
    public boolean isSlotEnabled() {
        if (this.host == null) {
            return false;
        }
        return this.host.isSlotEnabled(this.groupNum);
    }

    @Override
    public boolean isRenderDisabled() {
        return this.renderDisabled;
    }

    public void setRenderDisabled(boolean renderDisabled) {
        this.renderDisabled = renderDisabled;
    }

    @Override
    public int getSourceX() {
        return this.srcX;
    }

    @Override
    public int getSourceY() {
        return this.srcY;
    }
}

