/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.spatial.SpatialIOPortTileEntity;
import appeng.util.Platform;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;

public class SpatialIOPortContainer
extends AEBaseContainer {
    public static ContainerType<SpatialIOPortContainer> TYPE;
    private static final ContainerHelper<SpatialIOPortContainer, SpatialIOPortTileEntity> helper;
    @GuiSync(value=0)
    public long currentPower;
    @GuiSync(value=1)
    public long maxPower;
    @GuiSync(value=2)
    public long reqPower;
    @GuiSync(value=3)
    public long eff;
    private IGrid network;
    private int delay = 40;
    @GuiSync(value=31)
    public int xSize;
    @GuiSync(value=32)
    public int ySize;
    @GuiSync(value=33)
    public int zSize;

    public SpatialIOPortContainer(int id, PlayerInventory ip, SpatialIOPortTileEntity spatialIOPort) {
        super(TYPE, id, ip, spatialIOPort, null);
        if (Platform.isServer()) {
            this.network = spatialIOPort.getGridNode(AEPartLocation.INTERNAL).getGrid();
        }
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.SPATIAL_STORAGE_CELLS, spatialIOPort.getInternalInventory(), 0, 52, 48, this.getPlayerInventory()));
        this.func_75146_a(new OutputSlot(spatialIOPort.getInternalInventory(), 1, 113, 48, RestrictedInputSlot.PlacableItemType.SPATIAL_STORAGE_CELLS.IIcon));
        this.bindPlayerInventory(ip, 0, 115);
    }

    public static SpatialIOPortContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            ++this.delay;
            if (this.delay > 15 && this.network != null) {
                this.delay = 0;
                IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
                ISpatialCache sc = (ISpatialCache)this.network.getCache(ISpatialCache.class);
                if (eg != null) {
                    this.setCurrentPower((long)(100.0 * eg.getStoredPower()));
                    this.setMaxPower((long)(100.0 * eg.getMaxStoredPower()));
                    this.setRequiredPower((long)(100.0 * (double)sc.requiredPower()));
                    this.setEfficency((long)(100.0f * sc.currentEfficiency()));
                    DimensionalCoord min = sc.getMin();
                    DimensionalCoord max = sc.getMax();
                    if (min != null && max != null && sc.isValidRegion()) {
                        this.xSize = sc.getMax().x - sc.getMin().x - 1;
                        this.ySize = sc.getMax().y - sc.getMin().y - 1;
                        this.zSize = sc.getMax().z - sc.getMin().z - 1;
                    } else {
                        this.xSize = 0;
                        this.ySize = 0;
                        this.zSize = 0;
                    }
                }
            }
        }
        super.func_75142_b();
    }

    public long getCurrentPower() {
        return this.currentPower;
    }

    private void setCurrentPower(long currentPower) {
        this.currentPower = currentPower;
    }

    public long getMaxPower() {
        return this.maxPower;
    }

    private void setMaxPower(long maxPower) {
        this.maxPower = maxPower;
    }

    public long getRequiredPower() {
        return this.reqPower;
    }

    private void setRequiredPower(long reqPower) {
        this.reqPower = reqPower;
    }

    public long getEfficency() {
        return this.eff;
    }

    private void setEfficency(long eff) {
        this.eff = eff;
    }

    static {
        helper = new ContainerHelper<SpatialIOPortContainer, SpatialIOPortTileEntity>(SpatialIOPortContainer::new, SpatialIOPortTileEntity.class, SecurityPermissions.BUILD);
    }
}

