/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.CraftingCPURecord;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.me.helpers.PlayerSource;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.parts.reporting.TerminalPart;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class CraftConfirmContainer
extends AEBaseContainer {
    public static ContainerType<CraftConfirmContainer> TYPE;
    private static final ContainerHelper<CraftConfirmContainer, ITerminalHost> helper;
    private final ArrayList<CraftingCPURecord> cpus = new ArrayList();
    private Future<ICraftingJob> job;
    private ICraftingJob result;
    @GuiSync(value=0)
    public long bytesUsed;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=4)
    public boolean simulation = true;
    @GuiSync(value=5)
    public int selectedCpu = -1;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public ITextComponent myName;

    public static CraftConfirmContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public CraftConfirmContainer(int id, PlayerInventory ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
    }

    public void cycleCpu(boolean next) {
        if (next) {
            this.setSelectedCpu(this.getSelectedCpu() + 1);
        } else {
            this.setSelectedCpu(this.getSelectedCpu() - 1);
        }
        if (this.getSelectedCpu() < -1) {
            this.setSelectedCpu(this.cpus.size() - 1);
        } else if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
        }
        if (this.getSelectedCpu() == -1) {
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName(null);
        } else {
            CraftingCPURecord cpu = this.cpus.get(this.getSelectedCpu());
            this.setName(cpu.getName());
            this.setCpuAvailableBytes(cpu.getSize());
            this.setCpuCoProcessors(cpu.getProcessors());
        }
    }

    @Override
    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
        ImmutableSet<ICraftingCPU> cpuSet = cc.getCpus();
        int matches = 0;
        boolean changed = false;
        for (ICraftingCPU c : cpuSet) {
            boolean matched;
            boolean found = false;
            for (CraftingCPURecord ccr : this.cpus) {
                if (ccr.getCpu() != c) continue;
                found = true;
                break;
            }
            if (matched = this.cpuMatches(c)) {
                ++matches;
            }
            if (found != !matched) continue;
            changed = true;
        }
        if (changed || this.cpus.size() != matches) {
            this.cpus.clear();
            for (ICraftingCPU c : cpuSet) {
                if (!this.cpuMatches(c)) continue;
                this.cpus.add(new CraftingCPURecord(c.getAvailableStorage(), c.getCoProcessors(), c));
            }
            this.sendCPUs();
        }
        this.setNoCPU(this.cpus.isEmpty());
        super.func_75142_b();
        if (this.getJob() != null && this.getJob().isDone()) {
            try {
                this.result = this.getJob().get();
                if (!this.result.isSimulation()) {
                    this.setSimulation(false);
                    if (this.isAutoStart()) {
                        this.startJob();
                        return;
                    }
                } else {
                    this.setSimulation(true);
                }
                try {
                    MEInventoryUpdatePacket a = new MEInventoryUpdatePacket(0);
                    MEInventoryUpdatePacket b = new MEInventoryUpdatePacket(1);
                    MEInventoryUpdatePacket c = this.result.isSimulation() ? new MEInventoryUpdatePacket(2) : null;
                    IItemList<IAEItemStack> plan = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                    this.result.populatePlan(plan);
                    this.setUsedBytes(this.result.getByteTotal());
                    for (IAEItemStack out : plan) {
                        IAEItemStack o = out.copy();
                        o.reset();
                        o.setStackSize(out.getStackSize());
                        IAEItemStack p = out.copy();
                        p.reset();
                        p.setStackSize(out.getCountRequestable());
                        IStorageGrid sg = (IStorageGrid)this.getGrid().getCache(IStorageGrid.class);
                        IMEMonitor<IAEItemStack> items = sg.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                        IAEItemStack m = null;
                        if (c != null && this.result.isSimulation()) {
                            m = o.copy();
                            if ((o = items.extractItems(o, Actionable.SIMULATE, this.getActionSource())) == null) {
                                o = m.copy();
                                o.setStackSize(0L);
                            }
                            m.setStackSize(m.getStackSize() - o.getStackSize());
                        }
                        if (o.getStackSize() > 0L) {
                            a.appendItem(o);
                        }
                        if (p.getStackSize() > 0L) {
                            b.appendItem(p);
                        }
                        if (c == null || m == null || m.getStackSize() <= 0L) continue;
                        c.appendItem(m);
                    }
                    for (IAEItemStack g : this.field_75149_d) {
                        if (!(g instanceof PlayerEntity)) continue;
                        NetworkHandler.instance().sendTo(a, (ServerPlayerEntity)g);
                        NetworkHandler.instance().sendTo(b, (ServerPlayerEntity)g);
                        if (c == null) continue;
                        NetworkHandler.instance().sendTo(c, (ServerPlayerEntity)g);
                    }
                }
                catch (IOException a) {
                }
            }
            catch (Throwable e) {
                this.getPlayerInv().field_70458_d.func_145747_a((ITextComponent)new StringTextComponent("Error: " + e.toString()), Util.field_240973_b_);
                AELog.debug(e);
                this.setValidContainer(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    private IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        return h.getActionableNode().getGrid();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.getAvailableStorage() >= this.getUsedBytes() && !c.isBusy();
    }

    private void sendCPUs() {
        Collections.sort(this.cpus);
        if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName(null);
        } else if (this.getSelectedCpu() != -1) {
            CraftingCPURecord cpu = this.cpus.get(this.getSelectedCpu());
            this.setName(cpu.getName());
            this.setCpuAvailableBytes(cpu.getSize());
            this.setCpuCoProcessors(cpu.getProcessors());
        }
    }

    public void startJob() {
        Object originalGui = null;
        IActionHost ah = this.getActionHost();
        if (ah instanceof WirelessTerminalGuiObject) {
            originalGui = WirelessTermContainer.TYPE;
        }
        if (ah instanceof TerminalPart) {
            originalGui = MEMonitorableContainer.TYPE;
        }
        if (ah instanceof CraftingTerminalPart) {
            originalGui = CraftingTermContainer.TYPE;
        }
        if (ah instanceof PatternTerminalPart) {
            originalGui = PatternTermContainer.TYPE;
        }
        if (this.result != null && !this.isSimulation()) {
            ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
            ICraftingLink g = cc.submitJob(this.result, null, this.getSelectedCpu() == -1 ? null : this.cpus.get(this.getSelectedCpu()).getCpu(), true, this.getActionSrc());
            this.setAutoStart(false);
            if (g != null && originalGui != null && this.getLocator() != null) {
                ContainerOpener.openContainer(originalGui, this.getPlayerInventory().field_70458_d, this.getLocator());
            }
        }
    }

    private IActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInv().field_70458_d, (IActionHost)this.getTarget());
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public void func_75134_a(PlayerEntity par1PlayerEntity) {
        super.func_75134_a(par1PlayerEntity);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public World getWorld() {
        return this.getPlayerInv().field_70458_d.field_70170_p;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public long getUsedBytes() {
        return this.bytesUsed;
    }

    private void setUsedBytes(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public long getCpuAvailableBytes() {
        return this.cpuBytesAvail;
    }

    private void setCpuAvailableBytes(long cpuBytesAvail) {
        this.cpuBytesAvail = cpuBytesAvail;
    }

    public int getCpuCoProcessors() {
        return this.cpuCoProcessors;
    }

    private void setCpuCoProcessors(int cpuCoProcessors) {
        this.cpuCoProcessors = cpuCoProcessors;
    }

    public int getSelectedCpu() {
        return this.selectedCpu;
    }

    private void setSelectedCpu(int selectedCpu) {
        this.selectedCpu = selectedCpu;
    }

    public ITextComponent getName() {
        return this.myName;
    }

    private void setName(@Nullable ITextComponent myName) {
        this.myName = myName;
    }

    public boolean hasNoCPU() {
        return this.noCPU;
    }

    private void setNoCPU(boolean noCPU) {
        this.noCPU = noCPU;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    private void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    private Future<ICraftingJob> getJob() {
        return this.job;
    }

    public void setJob(Future<ICraftingJob> job) {
        this.job = job;
    }

    static {
        helper = new ContainerHelper<CraftConfirmContainer, ITerminalHost>(CraftConfirmContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

