/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.guisync;

import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.ProgressBarPacket;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class SyncData {
    private final AEBaseContainer source;
    private final Field field;
    private final Class<?> fieldType;
    private final int channel;
    private final MethodHandle getter;
    private final MethodHandle setter;
    private Object clientVersion = null;

    public SyncData(AEBaseContainer container, Field field, GuiSync annotation) {
        this.source = container;
        this.channel = annotation.value();
        this.field = field;
        this.fieldType = field.getType();
        try {
            this.getter = MethodHandles.publicLookup().unreflectGetter(field);
            this.setter = MethodHandles.publicLookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get accessor for field " + field + ". Did you forget to make it public?");
        }
    }

    public int getChannel() {
        return this.channel;
    }

    public void tick(IContainerListener c) {
        try {
            Object val = this.getter.invoke(this.source);
            if (!Objects.equals(val, this.clientVersion)) {
                this.send(c, val);
            }
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void send(IContainerListener o, Object val) {
        if (this.fieldType.isAssignableFrom(ITextComponent.class) && o instanceof ServerPlayerEntity) {
            String json = "";
            if (val != null) {
                json = ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)val));
            }
            NetworkHandler.instance().sendTo(new ConfigValuePacket("SyncDat." + this.channel, json), (ServerPlayerEntity)o);
        }
        if (val == null) {
            return;
        }
        if (this.fieldType.equals(String.class)) {
            if (o instanceof ServerPlayerEntity) {
                NetworkHandler.instance().sendTo(new ConfigValuePacket("SyncDat." + this.channel, (String)val), (ServerPlayerEntity)o);
            }
        } else if (this.fieldType.isEnum()) {
            o.func_71112_a((Container)this.source, this.channel, ((Enum)val).ordinal());
        } else if (val instanceof Long) {
            if (o instanceof ServerPlayerEntity) {
                NetworkHandler.instance().sendTo(new ProgressBarPacket(this.channel, (Long)val), (ServerPlayerEntity)o);
            }
        } else if (this.fieldType.equals(Boolean.class) || this.fieldType.equals(Boolean.TYPE)) {
            o.func_71112_a((Container)this.source, this.channel, (Boolean)val != false ? 1 : 0);
        } else if (this.fieldType.equals(Integer.class) || this.fieldType.equals(Integer.TYPE)) {
            o.func_71112_a((Container)this.source, this.channel, ((Integer)val).intValue());
        } else {
            throw new IllegalStateException("Unknown field type: " + this.fieldType);
        }
        this.clientVersion = val;
    }

    public void update(Object val) {
        try {
            Object oldValue = this.getter.invoke(this.source);
            if (val instanceof String) {
                if (this.fieldType.isAssignableFrom(ITextComponent.class)) {
                    String json = (String)val;
                    IFormattableTextComponent text = null;
                    if (!json.isEmpty()) {
                        text = ITextComponent.Serializer.func_240643_a_((String)((String)val));
                    }
                    this.updateTextComponent((ITextComponent)text);
                } else {
                    this.updateString((String)val);
                }
            } else {
                this.updateValue(oldValue, (Long)val);
            }
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void updateString(String val) {
        try {
            this.setter.invoke(this.source, val);
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void updateTextComponent(ITextComponent val) {
        try {
            this.setter.invoke(this.source, val);
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void updateValue(Object oldValue, long val) {
        try {
            if (this.fieldType.isEnum()) {
                Object e = this.fieldType.getEnumConstants()[(int)val];
                this.setter.invoke(this.source, e);
            } else if (this.fieldType.equals(Integer.TYPE)) {
                this.setter.invoke(this.source, (int)val);
            } else if (this.fieldType.equals(Long.TYPE)) {
                this.setter.invoke(this.source, val);
            } else if (this.fieldType.equals(Boolean.TYPE)) {
                this.setter.invoke(this.source, val == 1L);
            } else if (this.fieldType.equals(Integer.class)) {
                this.setter.invoke(this.source, (int)val);
            } else if (this.fieldType.equals(Long.class)) {
                this.setter.invoke(this.source, val);
            } else if (this.fieldType.equals(Boolean.class)) {
                this.setter.invoke(this.source, val == 1L);
            }
            this.source.onUpdate(this.field.getName(), oldValue, this.getter.invoke(this.source));
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }
}

