/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.DelegateBakedModel;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.AEModelData;
import appeng.client.render.model.AutoRotatingCacheKey;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

public class AutoRotatingBakedModel
extends DelegateBakedModel {
    private final IBakedModel parent;
    private final LoadingCache<AutoRotatingCacheKey, List<BakedQuad>> quadCache;

    public AutoRotatingBakedModel(IBakedModel parent) {
        super(parent);
        this.parent = parent;
        this.quadCache = CacheBuilder.newBuilder().maximumSize(252L).build((CacheLoader)new CacheLoader<AutoRotatingCacheKey, List<BakedQuad>>(){

            public List<BakedQuad> load(AutoRotatingCacheKey key) {
                return AutoRotatingBakedModel.this.getRotatedModel(key.getBlockState(), key.getSide(), new Random(0L), key.getModelData());
            }
        });
    }

    private List<BakedQuad> getRotatedModel(BlockState state, Direction side, Random rand, AEModelData modelData) {
        FacingToRotation f2r = FacingToRotation.get(modelData.getForward(), modelData.getUp());
        if (f2r.isRedundant()) {
            return this.parent.getQuads(state, side, rand, (IModelData)modelData);
        }
        List original = this.parent.getQuads(state, f2r.resultingRotate(side), rand, (IModelData)modelData);
        ArrayList<BakedQuad> rotated = new ArrayList<BakedQuad>(original.size());
        for (BakedQuad quad : original) {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            VertexRotator rot = new VertexRotator(f2r, quad.func_178210_d());
            rot.setParent((IVertexConsumer)builder);
            quad.pipe((IVertexConsumer)rot);
            if (quad.func_178210_d() != null) {
                builder.setQuadOrientation(f2r.rotate(quad.func_178210_d()));
            } else {
                builder.setQuadOrientation(null);
            }
            BakedQuad unpackedQuad = builder.build();
            BakedQuad packedQuad = new BakedQuad(unpackedQuad.func_178209_a(), quad.func_178211_c(), unpackedQuad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_());
            rotated.add(packedQuad);
        }
        return rotated;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (!(extraData instanceof AEModelData)) {
            return this.parent.getQuads(state, side, rand, extraData);
        }
        AEModelData aeModelData = (AEModelData)extraData;
        if (aeModelData.isCacheable()) {
            return (List)this.quadCache.getUnchecked((Object)new AutoRotatingCacheKey(state, aeModelData, side));
        }
        return this.getRotatedModel(state, side, rand, aeModelData);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return this.parent.getModelData(world, pos, state, tileData);
    }

    public static class VertexRotator
    extends QuadGatheringTransformer {
        private final FacingToRotation f2r;
        private final Direction face;
        private static final float EPS = 1.0E-4f;

        public VertexRotator(FacingToRotation f2r, Direction face) {
            this.f2r = f2r;
            this.face = face;
        }

        public void setParent(IVertexConsumer parent) {
            super.setParent(parent);
            if (Objects.equal((Object)this.getVertexFormat(), (Object)parent.getVertexFormat())) {
                return;
            }
            this.setVertexFormat(parent.getVertexFormat());
        }

        protected void processQuad() {
            VertexFormat format = this.parent.getVertexFormat();
            ImmutableList elements = format.func_227894_c_();
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < elements.size(); ++e) {
                    VertexFormatElement element = (VertexFormatElement)elements.get(e);
                    if (element.func_177375_c() == VertexFormatElement.Usage.POSITION) {
                        this.parent.put(e, this.transform(this.quadData[e][v]));
                        continue;
                    }
                    if (element.func_177375_c() == VertexFormatElement.Usage.NORMAL) {
                        this.parent.put(e, this.transformNormal(this.quadData[e][v]));
                        continue;
                    }
                    this.parent.put(e, this.quadData[e][v]);
                }
            }
        }

        private float[] transform(float[] fs) {
            switch (fs.length) {
                case 3: {
                    Vector4f vec = new Vector4f(fs[0], fs[1], fs[2], 1.0f);
                    vec.setX(vec.func_195910_a() - 0.5f);
                    vec.setY(vec.func_195913_b() - 0.5f);
                    vec.setZ(vec.func_195914_c() - 0.5f);
                    vec.func_229372_a_(this.f2r.getMat());
                    vec.setX(vec.func_195910_a() + 0.5f);
                    vec.setY(vec.func_195913_b() + 0.5f);
                    vec.setZ(vec.func_195914_c() + 0.5f);
                    return new float[]{VertexRotator.snap(vec.func_195910_a()), VertexRotator.snap(vec.func_195913_b()), VertexRotator.snap(vec.func_195914_c())};
                }
                case 4: {
                    Vector4f vecc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                    vecc.setX(vecc.func_195910_a() - 0.5f);
                    vecc.setY(vecc.func_195913_b() - 0.5f);
                    vecc.setZ(vecc.func_195914_c() - 0.5f);
                    vecc.func_229372_a_(this.f2r.getMat());
                    vecc.setX(vecc.func_195910_a() + 0.5f);
                    vecc.setY(vecc.func_195913_b() + 0.5f);
                    vecc.setZ(vecc.func_195914_c() + 0.5f);
                    return new float[]{VertexRotator.snap(vecc.func_195910_a()), VertexRotator.snap(vecc.func_195913_b()), VertexRotator.snap(vecc.func_195914_c()), VertexRotator.snap(vecc.func_195915_d())};
                }
            }
            return fs;
        }

        private static float snap(float x) {
            if (Math.abs(x) <= 1.0E-4f) {
                return 0.0f;
            }
            if (Math.abs(x - 1.0f) <= 1.0E-4f) {
                return 1.0f;
            }
            return x;
        }

        private float[] transformNormal(float[] fs) {
            if (this.face == null) {
                switch (fs.length) {
                    case 3: {
                        Vector4f vec = new Vector4f(fs[0], fs[1], fs[2], 0.0f);
                        vec.func_229372_a_(this.f2r.getMat());
                        return new float[]{vec.func_195910_a(), vec.func_195913_b(), vec.func_195914_c()};
                    }
                    case 4: {
                        Vector4f vec4 = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                        vec4.func_229372_a_(this.f2r.getMat());
                        return new float[]{VertexRotator.snap(vec4.func_195910_a()), VertexRotator.snap(vec4.func_195913_b()), VertexRotator.snap(vec4.func_195914_c()), 0.0f};
                    }
                }
                return fs;
            }
            switch (fs.length) {
                case 3: {
                    Vector3i vec = this.f2r.rotate(this.face).func_176730_m();
                    return new float[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()};
                }
                case 4: {
                    Vector4f veccc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                    Vector3i vecc = this.f2r.rotate(this.face).func_176730_m();
                    return new float[]{vecc.func_177958_n(), vecc.func_177956_o(), vecc.func_177952_p(), veccc.func_195915_d()};
                }
            }
            return fs;
        }

        public void setQuadTint(int tint) {
            this.parent.setQuadTint(tint);
        }

        public void setQuadOrientation(Direction orientation) {
            this.parent.setQuadOrientation(this.f2r.rotate(orientation));
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.parent.setApplyDiffuseLighting(diffuse);
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.parent.setTexture(texture);
        }
    }
}

