/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.crafting.LightBakedModel;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.crafting.UnitBakedModel;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

class CraftingCubeModel
implements BasicUnbakedModel<CraftingCubeModel> {
    private static final RenderMaterial RING_CORNER = CraftingCubeModel.texture("ring_corner");
    private static final RenderMaterial RING_SIDE_HOR = CraftingCubeModel.texture("ring_side_hor");
    private static final RenderMaterial RING_SIDE_VER = CraftingCubeModel.texture("ring_side_ver");
    private static final RenderMaterial UNIT_BASE = CraftingCubeModel.texture("unit_base");
    private static final RenderMaterial LIGHT_BASE = CraftingCubeModel.texture("light_base");
    private static final RenderMaterial ACCELERATOR_LIGHT = CraftingCubeModel.texture("accelerator_light");
    private static final RenderMaterial STORAGE_1K_LIGHT = CraftingCubeModel.texture("1k_storage_light");
    private static final RenderMaterial STORAGE_4K_LIGHT = CraftingCubeModel.texture("4k_storage_light");
    private static final RenderMaterial STORAGE_16K_LIGHT = CraftingCubeModel.texture("16k_storage_light");
    private static final RenderMaterial STORAGE_64K_LIGHT = CraftingCubeModel.texture("64k_storage_light");
    private static final RenderMaterial MONITOR_BASE = CraftingCubeModel.texture("monitor_base");
    private static final RenderMaterial MONITOR_LIGHT_DARK = CraftingCubeModel.texture("monitor_light_dark");
    private static final RenderMaterial MONITOR_LIGHT_MEDIUM = CraftingCubeModel.texture("monitor_light_medium");
    private static final RenderMaterial MONITOR_LIGHT_BRIGHT = CraftingCubeModel.texture("monitor_light_bright");
    private final AbstractCraftingUnitBlock.CraftingUnitType type;

    CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType type) {
        this.type = type;
    }

    @Override
    public Stream<RenderMaterial> getAdditionalTextures() {
        return Stream.of(RING_CORNER, RING_SIDE_HOR, RING_SIDE_VER, UNIT_BASE, LIGHT_BASE, ACCELERATOR_LIGHT, STORAGE_1K_LIGHT, STORAGE_4K_LIGHT, STORAGE_16K_LIGHT, STORAGE_64K_LIGHT, MONITOR_BASE, MONITOR_LIGHT_DARK, MONITOR_LIGHT_MEDIUM, MONITOR_LIGHT_BRIGHT);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite ringCorner = spriteGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        switch (this.type) {
            case UNIT: {
                return new UnitBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE));
            }
            case ACCELERATOR: 
            case STORAGE_1K: 
            case STORAGE_4K: 
            case STORAGE_16K: 
            case STORAGE_64K: {
                return new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(LIGHT_BASE), CraftingCubeModel.getLightTexture(spriteGetter, this.type));
            }
            case MONITOR: {
                return new MonitorBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE), spriteGetter.apply(MONITOR_BASE), spriteGetter.apply(MONITOR_LIGHT_DARK), spriteGetter.apply(MONITOR_LIGHT_MEDIUM), spriteGetter.apply(MONITOR_LIGHT_BRIGHT));
            }
        }
        throw new IllegalArgumentException("Unsupported crafting unit type: " + (Object)((Object)this.type));
    }

    private static TextureAtlasSprite getLightTexture(Function<RenderMaterial, TextureAtlasSprite> textureGetter, AbstractCraftingUnitBlock.CraftingUnitType type) {
        switch (type) {
            case ACCELERATOR: {
                return textureGetter.apply(ACCELERATOR_LIGHT);
            }
            case STORAGE_1K: {
                return textureGetter.apply(STORAGE_1K_LIGHT);
            }
            case STORAGE_4K: {
                return textureGetter.apply(STORAGE_4K_LIGHT);
            }
            case STORAGE_16K: {
                return textureGetter.apply(STORAGE_16K_LIGHT);
            }
            case STORAGE_64K: {
                return textureGetter.apply(STORAGE_64K_LIGHT);
            }
        }
        throw new IllegalArgumentException("Crafting unit type " + (Object)((Object)type) + " does not use a light texture.");
    }

    private static RenderMaterial texture(String name) {
        return new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/crafting/" + name));
    }
}

