/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AEAxisAlignedBB;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.FacadeBlockAccess;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.client.render.cablebus.QuadRotator;
import appeng.core.Api;
import appeng.parts.misc.CableAnchorPart;
import appeng.thirdparty.codechicken.lib.model.CachedFormat;
import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.BakedPipeline;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadAlphaOverride;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadClamper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadCornerKicker;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadFaceStripper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadReInterpolator;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadTinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class FacadeBuilder {
    public static final double THICK_THICKNESS = 0.125;
    public static final double THIN_THICKNESS = 0.0625;
    public static final AxisAlignedBB[] THICK_FACADE_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB[] THIN_FACADE_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final ThreadLocal<BakedPipeline> pipelines = ThreadLocal.withInitial(() -> BakedPipeline.builder().addElement("clamper", QuadClamper.FACTORY).addElement("face_stripper", QuadFaceStripper.FACTORY).addElement("corner_kicker", QuadCornerKicker.FACTORY).addElement("interp", QuadReInterpolator.FACTORY).addElement("tinter", QuadTinter.FACTORY, false).addElement("transparent", QuadAlphaOverride.FACTORY, false, e -> e.setAlphaOverride(0.29803923f)).build());
    private final ThreadLocal<Quad> collectors = ThreadLocal.withInitial(Quad::new);

    public void buildFacadeQuads(RenderType layer, CableBusRenderState renderState, Random rand, List<BakedQuad> quads, Function<ResourceLocation, IBakedModel> modelLookup) {
        BakedPipeline pipeline = this.pipelines.get();
        Quad collectorQuad = this.collectors.get();
        boolean transparent = Api.instance().partHelper().getCableRenderMode().transparentFacades;
        EnumMap<Direction, FacadeRenderState> facadeStates = renderState.getFacades();
        List<AxisAlignedBB> partBoxes = renderState.getBoundingBoxes();
        Set<Direction> sidesWithParts = renderState.getAttachments().keySet();
        IBlockDisplayReader parentWorld = renderState.getWorld();
        BlockPos pos = renderState.getPos();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        boolean thinFacades = FacadeBuilder.isUseThinFacades(partBoxes);
        for (Map.Entry entry : facadeStates.entrySet()) {
            Object otherState;
            AxisAlignedBB fullBounds;
            boolean renderStilt;
            Direction side = (Direction)entry.getKey();
            int sideIndex = side.ordinal();
            FacadeRenderState facadeRenderState = (FacadeRenderState)entry.getValue();
            boolean bl = renderStilt = !sidesWithParts.contains(side);
            if (layer == RenderType.func_228643_e_() && renderStilt) {
                for (ResourceLocation part : CableAnchorPart.FACADE_MODELS.getModels()) {
                    IBakedModel partModel = modelLookup.apply(part);
                    QuadRotator rotator = new QuadRotator();
                    quads.addAll(rotator.rotateQuads(FacadeBuilder.gatherQuads(partModel, null, rand, (IModelData)EmptyModelData.INSTANCE), side, Direction.UP));
                }
            }
            if (transparent && layer != RenderType.func_228645_f_()) continue;
            BlockState blockState = facadeRenderState.getSourceBlock();
            if (!transparent && layer != null && !RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
            AxisAlignedBB facadeBox = fullBounds = thinFacades ? THIN_FACADE_BOXES[sideIndex] : THICK_FACADE_BOXES[sideIndex];
            if (facadeRenderState.isTransparent()) {
                double offset = thinFacades ? 0.0625 : 0.125;
                AEAxisAlignedBB tmpBB = null;
                block10: for (Direction face : Direction.values()) {
                    if (face.func_176740_k() == side.func_176740_k() || (otherState = (FacadeRenderState)facadeStates.get(face)) == null || ((FacadeRenderState)otherState).isTransparent()) continue;
                    if (tmpBB == null) {
                        tmpBB = AEAxisAlignedBB.fromBounds(facadeBox);
                    }
                    switch (face) {
                        case DOWN: {
                            tmpBB.minY += offset;
                            continue block10;
                        }
                        case UP: {
                            tmpBB.maxY -= offset;
                            continue block10;
                        }
                        case NORTH: {
                            tmpBB.minZ += offset;
                            continue block10;
                        }
                        case SOUTH: {
                            tmpBB.maxZ -= offset;
                            continue block10;
                        }
                        case WEST: {
                            tmpBB.minX += offset;
                            continue block10;
                        }
                        case EAST: {
                            tmpBB.maxX -= offset;
                            continue block10;
                        }
                        default: {
                            throw new RuntimeException("Switch falloff. " + String.valueOf(face));
                        }
                    }
                }
                if (tmpBB != null) {
                    facadeBox = tmpBB.getBoundingBox();
                }
            }
            AEAxisAlignedBB cutOutBox = FacadeBuilder.getCutOutBox(facadeBox, partBoxes);
            List<AxisAlignedBB> holeStrips = FacadeBuilder.getBoxes(facadeBox, cutOutBox, side.func_176740_k());
            FacadeBlockAccess facadeAccess = new FacadeBlockAccess(parentWorld, pos, side, blockState);
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel model = dispatcher.func_184389_a(blockState);
            IModelData modelData = model.getModelData((IBlockDisplayReader)facadeAccess, pos, blockState, (IModelData)EmptyModelData.INSTANCE);
            ArrayList<BakedQuad> modelQuads = new ArrayList<BakedQuad>();
            if (transparent || layer == null) {
                otherState = RenderType.func_228661_n_().iterator();
                while (otherState.hasNext()) {
                    RenderType forcedLayer = (RenderType)otherState.next();
                    if (!RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)forcedLayer)) continue;
                    ForgeHooksClient.setRenderLayer((RenderType)forcedLayer);
                    modelQuads.addAll(FacadeBuilder.gatherQuads(model, blockState, rand, modelData));
                }
                ForgeHooksClient.setRenderLayer((RenderType)layer);
            } else {
                modelQuads.addAll(FacadeBuilder.gatherQuads(model, blockState, rand, modelData));
            }
            if (modelQuads.isEmpty()) continue;
            QuadClamper clamper = pipeline.getElement("clamper", QuadClamper.class);
            QuadFaceStripper edgeStripper = pipeline.getElement("face_stripper", QuadFaceStripper.class);
            QuadTinter tinter = pipeline.getElement("tinter", QuadTinter.class);
            QuadCornerKicker kicker = pipeline.getElement("corner_kicker", QuadCornerKicker.class);
            int facadeMask = 0;
            for (Map.Entry ent : facadeStates.entrySet()) {
                FacadeRenderState otherState2;
                Direction s = (Direction)ent.getKey();
                if (s.func_176740_k() == side.func_176740_k() || (otherState2 = (FacadeRenderState)ent.getValue()).isTransparent()) continue;
                facadeMask |= 1 << s.ordinal();
            }
            edgeStripper.setBounds(fullBounds);
            edgeStripper.setMask(facadeMask);
            kicker.setSide(sideIndex);
            kicker.setFacadeMask(facadeMask);
            kicker.setBox(fullBounds);
            kicker.setThickness(thinFacades ? 0.0625 : 0.125);
            for (BakedQuad quad : modelQuads) {
                CachedFormat format = CachedFormat.lookup(DefaultVertexFormats.field_176600_a);
                if (quad.func_178212_b()) {
                    tinter.setTint(blockColors.func_228054_a_(blockState, (IBlockDisplayReader)facadeAccess, pos, quad.func_178211_c()));
                }
                for (AxisAlignedBB box : holeStrips) {
                    clamper.setClampBounds(box);
                    pipeline.reset(format);
                    collectorQuad.reset(format);
                    pipeline.setElementState("tinter", quad.func_178212_b());
                    pipeline.setElementState("transparent", transparent);
                    pipeline.prepare(collectorQuad);
                    quad.pipe((IVertexConsumer)pipeline);
                    if (!collectorQuad.full) continue;
                    quads.add(collectorQuad.bake());
                }
            }
        }
    }

    public List<BakedQuad> buildFacadeItemQuads(ItemStack textureItem, Direction side) {
        ArrayList<BakedQuad> facadeQuads = new ArrayList<BakedQuad>();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(textureItem, null, null);
        List<BakedQuad> modelQuads = FacadeBuilder.gatherQuads(model, null, new Random(), (IModelData)EmptyModelData.INSTANCE);
        BakedPipeline pipeline = this.pipelines.get();
        Quad collectorQuad = this.collectors.get();
        QuadClamper clamper = pipeline.getElement("clamper", QuadClamper.class);
        QuadTinter tinter = pipeline.getElement("tinter", QuadTinter.class);
        for (BakedQuad quad : modelQuads) {
            CachedFormat format = CachedFormat.lookup(DefaultVertexFormats.field_176600_a);
            pipeline.reset(format);
            collectorQuad.reset(format);
            if (quad.func_178212_b()) {
                tinter.setTint(Minecraft.func_71410_x().getItemColors().func_186728_a(textureItem, quad.func_178211_c()));
                pipeline.enableElement("tinter");
            }
            pipeline.disableElement("face_stripper");
            pipeline.disableElement("corner_kicker");
            clamper.setClampBounds(THICK_FACADE_BOXES[side.ordinal()]);
            pipeline.prepare(collectorQuad);
            quad.pipe((IVertexConsumer)pipeline);
            if (!collectorQuad.full) continue;
            facadeQuads.add(collectorQuad.bake());
        }
        return facadeQuads;
    }

    private static List<BakedQuad> gatherQuads(IBakedModel model, BlockState state, Random rand, IModelData data) {
        ArrayList<BakedQuad> modelQuads = new ArrayList<BakedQuad>();
        for (Direction face : Direction.values()) {
            modelQuads.addAll(model.getQuads(state, face, rand, data));
        }
        modelQuads.addAll(model.getQuads(state, null, rand, data));
        return modelQuads;
    }

    @Nullable
    private static AEAxisAlignedBB getCutOutBox(AxisAlignedBB facadeBox, List<AxisAlignedBB> partBoxes) {
        AEAxisAlignedBB b = null;
        for (AxisAlignedBB bb : partBoxes) {
            if (!bb.func_72326_a(facadeBox)) continue;
            if (b == null) {
                b = AEAxisAlignedBB.fromBounds(bb);
                continue;
            }
            b.maxX = Math.max(b.maxX, bb.field_72336_d);
            b.maxY = Math.max(b.maxY, bb.field_72337_e);
            b.maxZ = Math.max(b.maxZ, bb.field_72334_f);
            b.minX = Math.min(b.minX, bb.field_72340_a);
            b.minY = Math.min(b.minY, bb.field_72338_b);
            b.minZ = Math.min(b.minZ, bb.field_72339_c);
        }
        return b;
    }

    private static List<AxisAlignedBB> getBoxes(AxisAlignedBB fb, AEAxisAlignedBB hole, Direction.Axis axis) {
        if (hole == null) {
            return Collections.singletonList(fb);
        }
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        switch (axis) {
            case Y: {
                boxes.add(new AxisAlignedBB(fb.field_72340_a, fb.field_72338_b, fb.field_72339_c, hole.minX, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(hole.maxX, fb.field_72338_b, fb.field_72339_c, fb.field_72336_d, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(hole.minX, fb.field_72338_b, fb.field_72339_c, hole.maxX, fb.field_72337_e, hole.minZ));
                boxes.add(new AxisAlignedBB(hole.minX, fb.field_72338_b, hole.maxZ, hole.maxX, fb.field_72337_e, fb.field_72334_f));
                break;
            }
            case Z: {
                boxes.add(new AxisAlignedBB(fb.field_72340_a, fb.field_72338_b, fb.field_72339_c, fb.field_72336_d, hole.minY, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.maxY, fb.field_72339_c, fb.field_72336_d, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.minY, fb.field_72339_c, hole.minX, hole.maxY, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(hole.maxX, hole.minY, fb.field_72339_c, fb.field_72336_d, hole.maxY, fb.field_72334_f));
                break;
            }
            case X: {
                boxes.add(new AxisAlignedBB(fb.field_72340_a, fb.field_72338_b, fb.field_72339_c, fb.field_72336_d, hole.minY, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.maxY, fb.field_72339_c, fb.field_72336_d, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.minY, fb.field_72339_c, fb.field_72336_d, hole.maxY, hole.minZ));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.minY, hole.maxZ, fb.field_72336_d, hole.maxY, fb.field_72334_f));
                break;
            }
            default: {
                throw new RuntimeException("switch falloff. " + String.valueOf(axis));
            }
        }
        return boxes;
    }

    private static boolean isUseThinFacades(List<AxisAlignedBB> partBoxes) {
        double min = 0.125;
        double max = 0.875;
        for (AxisAlignedBB bb : partBoxes) {
            int o = 0;
            o += bb.field_72336_d > 0.875 ? 1 : 0;
            o += bb.field_72337_e > 0.875 ? 1 : 0;
            o += bb.field_72334_f > 0.875 ? 1 : 0;
            o += bb.field_72340_a < 0.125 ? 1 : 0;
            o += bb.field_72338_b < 0.125 ? 1 : 0;
            if ((o += bb.field_72339_c < 0.125 ? 1 : 0) < 2) continue;
            return true;
        }
        return false;
    }
}

