/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.IScrollSource;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class Scrollbar
implements IScrollSource {
    private int displayX = 0;
    private int displayY = 0;
    private int width = 12;
    private int height = 16;
    private int pageSize = 1;
    private int maxScroll = 0;
    private int minScroll = 0;
    private int currentScroll = 0;

    public void draw(AEBaseScreen<?> g) {
        g.bindTexture("minecraft", "gui/container/creative_inventory/tabs.png");
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getRange() == 0) {
            GuiUtils.drawTexturedModalRect((int)this.displayX, (int)this.displayY, (int)(232 + this.width), (int)0, (int)this.width, (int)15, (float)g.func_230927_p_());
        } else {
            int offset = (this.currentScroll - this.minScroll) * (this.height - 15) / this.getRange();
            GuiUtils.drawTexturedModalRect((int)this.displayX, (int)(offset + this.displayY), (int)232, (int)0, (int)this.width, (int)15, (float)g.func_230927_p_());
        }
    }

    private int getRange() {
        return this.maxScroll - this.minScroll;
    }

    public int getLeft() {
        return this.displayX;
    }

    public Scrollbar setLeft(int v) {
        this.displayX = v;
        return this;
    }

    public int getTop() {
        return this.displayY;
    }

    public Scrollbar setTop(int v) {
        this.displayY = v;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public Scrollbar setWidth(int v) {
        this.width = v;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public Scrollbar setHeight(int v) {
        this.height = v;
        return this;
    }

    public void setRange(int min, int max, int pageSize) {
        this.minScroll = min;
        this.maxScroll = max;
        this.pageSize = pageSize;
        if (this.minScroll > this.maxScroll) {
            this.maxScroll = this.minScroll;
        }
        this.applyRange();
    }

    private void applyRange() {
        this.currentScroll = Math.max(Math.min(this.currentScroll, this.maxScroll), this.minScroll);
    }

    @Override
    public int getCurrentScroll() {
        return this.currentScroll;
    }

    public void click(double x, double y) {
        if (this.getRange() == 0) {
            return;
        }
        if (x > (double)this.displayX && x <= (double)(this.displayX + this.width) && y > (double)this.displayY && y <= (double)(this.displayY + this.height)) {
            this.currentScroll = (int)(y - (double)this.displayY);
            this.currentScroll = this.minScroll + this.currentScroll * 2 * this.getRange() / this.height;
            this.currentScroll = this.currentScroll + 1 >> 1;
            this.applyRange();
        }
    }

    public void wheel(double delta) {
        delta = Math.max(Math.min(-delta, 1.0), -1.0);
        this.currentScroll = (int)((double)this.currentScroll + delta * (double)this.pageSize);
        this.applyRange();
    }
}

