/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import appeng.container.interfaces.IProgressProvider;
import appeng.core.localization.GuiText;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ProgressBar
extends Widget
implements ITooltip {
    private final IProgressProvider source;
    private final ResourceLocation texture;
    private final int fill_u;
    private final int fill_v;
    private final Direction layout;
    private final ITextComponent titleName;
    private ITextComponent fullMsg;

    public ProgressBar(IProgressProvider source, String texture, int posX, int posY, int u, int y, int width, int height, Direction dir) {
        this(source, texture, posX, posY, u, y, width, height, dir, null);
    }

    public ProgressBar(IProgressProvider source, String texture, int posX, int posY, int u, int y, int width, int height, Direction dir, ITextComponent title) {
        super(posX, posY, width, height, StringTextComponent.field_240750_d_);
        this.source = source;
        this.texture = new ResourceLocation("appliedenergistics2", "textures/" + texture);
        this.fill_u = u;
        this.fill_v = y;
        this.layout = dir;
        this.titleName = title;
    }

    public void func_230431_b_(MatrixStack matrixStack, int par2, int par3, float partial) {
        if (this.field_230694_p_) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
            int max = this.source.getMaxProgress();
            int current = this.source.getCurrentProgress();
            if (this.layout == Direction.VERTICAL) {
                int diff = this.field_230689_k_ - (max > 0 ? this.field_230689_k_ * current / max : 0);
                GuiUtils.drawTexturedModalRect((int)this.field_230690_l_, (int)(this.field_230691_m_ + diff), (int)this.fill_u, (int)(this.fill_v + diff), (int)this.field_230688_j_, (int)(this.field_230689_k_ - diff), (float)0.0f);
            } else {
                int diff = this.field_230688_j_ - (max > 0 ? this.field_230688_j_ * current / max : 0);
                GuiUtils.drawTexturedModalRect((int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.fill_u + diff), (int)this.fill_v, (int)(this.field_230688_j_ - diff), (int)this.field_230689_k_, (float)0.0f);
            }
        }
    }

    public void setFullMsg(ITextComponent msg) {
        this.fullMsg = msg;
    }

    @Override
    public ITextComponent getTooltipMessage() {
        if (this.fullMsg != null) {
            return this.fullMsg;
        }
        ITextComponent result = this.titleName != null ? this.titleName : StringTextComponent.field_240750_d_;
        return result.func_230532_e_().func_240702_b_("\n").func_240702_b_(this.source.getCurrentProgress() + " ").func_230529_a_((ITextComponent)GuiText.Of.text().func_230532_e_().func_240702_b_(" " + this.source.getMaxProgress()));
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_ - 2;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_ - 2;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.field_230688_j_ + 4;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.field_230689_k_ + 4;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

