/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import java.util.function.LongConsumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class NumberBox
extends TextFieldWidget {
    private final LongConsumer changeListener;
    private long lastValue;
    private long minValue = 0L;
    private long maxValue;

    public NumberBox(FontRenderer fontRenderer, int x, int y, int width, int height, Class<?> type, LongConsumer changeListener) {
        super(fontRenderer, x, y, width, height, (ITextComponent)new StringTextComponent("0"));
        this.func_146180_a("0");
        this.func_212954_a(this::handleTextChanged);
        this.lastValue = 0L;
        this.changeListener = changeListener;
        this.maxValue = type == Integer.TYPE || type == Integer.class ? Integer.MAX_VALUE : Long.MAX_VALUE;
    }

    private void handleTextChanged(String text) {
        String sanitizedStr;
        if (text.isEmpty()) {
            this.func_146180_a("0");
            return;
        }
        boolean canBeNegative = this.canBeNegative();
        if (canBeNegative && text.equals("-")) {
            return;
        }
        StringBuilder sanitized = new StringBuilder(text);
        boolean encounteredNonZero = false;
        for (int i = 0; i < sanitized.length(); ++i) {
            char ch = sanitized.charAt(i);
            if (canBeNegative && i == 0 && ch == '-') continue;
            if (ch >= '1' && ch <= '9') {
                encounteredNonZero = true;
                continue;
            }
            if (ch == '0' && encounteredNonZero) continue;
            sanitized.deleteCharAt(i--);
        }
        if (sanitized.length() == 0) {
            sanitized.append('0');
        }
        if (!(sanitizedStr = sanitized.toString()).equals(text)) {
            this.func_146180_a(sanitizedStr);
            return;
        }
        if (this.getValue() < this.minValue) {
            this.func_146180_a(String.valueOf(this.minValue));
            return;
        }
        if (this.getValue() > this.maxValue) {
            this.func_146180_a(String.valueOf(this.maxValue));
            return;
        }
        this.reportChange();
    }

    private void reportChange() {
        long value = this.getValue();
        if (value != this.lastValue) {
            this.lastValue = value;
            this.changeListener.accept(value);
        }
    }

    public void setValue(long value, boolean skipNotify) {
        if (value == this.getValue()) {
            return;
        }
        if (skipNotify) {
            this.lastValue = value;
        }
        this.func_146180_a(String.valueOf(value));
    }

    public long getValue() {
        if (this.func_146179_b().equals("-") && this.canBeNegative()) {
            return this.lastValue;
        }
        return Long.parseLong(this.func_146179_b());
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        return this.func_230999_j_() && p_keyPressed_1_ >= 48 && p_keyPressed_1_ <= 57;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    private boolean canBeNegative() {
        return this.minValue < 0L;
    }
}

