/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public abstract class IconButton
extends Button
implements ITooltip {
    public static final ResourceLocation TEXTURE_STATES = new ResourceLocation("appliedenergistics2", "textures/guis/states.png");
    private boolean halfSize = false;

    public IconButton(int x, int y, Button.IPressable onPress) {
        super(x, y, 16, 16, StringTextComponent.field_240750_d_, onPress);
    }

    public void setVisibility(boolean vis) {
        this.field_230694_p_ = vis;
        this.field_230693_o_ = vis;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.field_230694_p_) {
            int iconIndex = this.getIconIndex();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(TEXTURE_STATES);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (this.halfSize) {
                this.field_230688_j_ = 8;
                this.field_230689_k_ = 8;
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)this.field_230690_l_, (float)this.field_230691_m_, (float)0.0f);
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                if (this.field_230693_o_) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                int uv_y = iconIndex / 16;
                int uv_x = iconIndex - uv_y * 16;
                GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)240, (int)240, (int)16, (int)16, (float)0.0f);
                GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)(uv_x * 16), (int)(uv_y * 16), (int)16, (int)16, (float)0.0f);
                RenderSystem.popMatrix();
            } else {
                if (this.field_230693_o_) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                int uv_y = iconIndex / 16;
                int uv_x = iconIndex - uv_y * 16;
                GuiUtils.drawTexturedModalRect((int)this.field_230690_l_, (int)this.field_230691_m_, (int)240, (int)240, (int)16, (int)16, (float)0.0f);
                GuiUtils.drawTexturedModalRect((int)this.field_230690_l_, (int)this.field_230691_m_, (int)(uv_x * 16), (int)(uv_y * 16), (int)16, (int)16, (float)0.0f);
            }
            RenderSystem.enableDepthTest();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected abstract int getIconIndex();

    @Override
    public ITextComponent getTooltipMessage() {
        return this.func_230458_i_();
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.field_230694_p_;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }
}

