/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.widgets.ITickingWidget;
import appeng.client.gui.widgets.NumberBox;
import appeng.core.AEConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class NumberEntryWidget
implements ITickingWidget {
    private static final ITextComponent PLUS = new StringTextComponent("+");
    private static final ITextComponent MINUS = new StringTextComponent("-");
    private final AEBaseScreen<?> parent;
    private final int x;
    private final int y;
    private final NumberBox level;
    private final NumberEntryType type;
    private List<Button> buttons;

    public NumberEntryWidget(AEBaseScreen<?> parent, int x, int y, int width, int height, NumberEntryType type, LongConsumer changeListener) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.type = type;
        FontRenderer font = parent.getMinecraft().field_71466_p;
        int inputX = parent.getGuiLeft() + x;
        int inputY = parent.getGuiTop() + y;
        font.getClass();
        this.level = new NumberBox(font, inputX, inputY, width, 9, type.getInputType(), changeListener);
        this.level.func_146185_a(false);
        this.level.func_146203_f(16);
        this.level.func_146193_g(0xFFFFFF);
        this.level.func_146189_e(true);
        this.level.func_146195_b(true);
        parent.func_212928_a((IGuiEventListener)this.level);
    }

    public void setActive(boolean active) {
        this.level.func_146184_c(active);
        this.buttons.forEach(b -> {
            b.field_230693_o_ = active;
        });
    }

    public void setTextFieldBounds(int x, int y, int width) {
        this.level.field_230690_l_ = this.parent.getGuiLeft() + x;
        this.level.field_230691_m_ = this.parent.getGuiTop() + y;
        this.level.func_230991_b_(width);
    }

    public void setMinValue(long minValue) {
        this.level.setMinValue(minValue);
    }

    public void addButtons(Consumer<IGuiEventListener> addChildren, Consumer<Button> addButton) {
        int[] steps = AEConfig.instance().getNumberEntrySteps(this.type);
        int a = steps[0];
        int b = steps[1];
        int c = steps[2];
        int d = steps[3];
        int left = this.parent.getGuiLeft() + this.x;
        int top = this.parent.getGuiTop() + this.y;
        ArrayList<Button> buttons = new ArrayList<Button>(8);
        buttons.add(new Button(left, top, 22, 20, this.makeLabel(PLUS, a), btn -> this.addQty(a)));
        buttons.add(new Button(left + 28, top, 28, 20, this.makeLabel(PLUS, b), btn -> this.addQty(b)));
        buttons.add(new Button(left + 62, top, 32, 20, this.makeLabel(PLUS, c), btn -> this.addQty(c)));
        buttons.add(new Button(left + 100, top, 38, 20, this.makeLabel(PLUS, d), btn -> this.addQty(d)));
        addChildren.accept((IGuiEventListener)this.level);
        buttons.add(new Button(left, top + 42, 22, 20, this.makeLabel(MINUS, a), btn -> this.addQty(-a)));
        buttons.add(new Button(left + 28, top + 42, 28, 20, this.makeLabel(MINUS, b), btn -> this.addQty(-b)));
        buttons.add(new Button(left + 62, top + 42, 32, 20, this.makeLabel(MINUS, c), btn -> this.addQty(-c)));
        buttons.add(new Button(left + 100, top + 42, 38, 20, this.makeLabel(MINUS, d), btn -> this.addQty(-d)));
        this.buttons = buttons;
        this.buttons.forEach(addButton);
    }

    private void addQty(long i) {
        long currentValue = this.level.getValue();
        long minValue = this.level.getMinValue();
        this.level.func_146180_a(String.valueOf(Math.max(minValue, currentValue + i)));
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.level.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void setValue(long value, boolean skipNotify) {
        this.level.setValue(value, skipNotify);
    }

    public void setValue(long value) {
        this.setValue(value, false);
    }

    public long getValue() {
        return this.level.getValue();
    }

    @Override
    public void tick() {
        this.level.func_146178_a();
    }

    private ITextComponent makeLabel(ITextComponent prefix, int amount) {
        return prefix.func_230531_f_().func_240702_b_(String.valueOf(amount));
    }
}

