/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseMEScreen;
import appeng.client.gui.implementations.MEPortableCellScreen;
import appeng.client.gui.implementations.SecurityStationScreen;
import appeng.client.gui.implementations.WirelessTermScreen;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.client.me.InternalSlotME;
import appeng.client.me.ItemRepo;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.CraftingStatusContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.CraftingMatrixSlot;
import appeng.container.slot.FakeCraftingMatrixSlot;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.integration.abstraction.JEIFacade;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.tile.misc.SecurityStationTileEntity;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class MEMonitorableScreen<T extends MEMonitorableContainer>
extends AEBaseMEScreen<T>
implements ISortSource,
IConfigManagerHost {
    private static int craftingGridOffsetX;
    private static int craftingGridOffsetY;
    private static String memoryText;
    private final ItemRepo repo;
    private final int offsetX = 9;
    private final int lowerTextureOffset = 0;
    private final IConfigManager configSrc;
    private final boolean viewCell;
    private final ItemStack[] myCurrentViewCells = new ItemStack[5];
    private TabButton craftingStatusBtn;
    private AETextField searchField;
    private GuiText myName;
    private int perRow = 9;
    private int reservedSpace = 0;
    private boolean customSortOrder = true;
    private int rows = 0;
    private int maxRows = Integer.MAX_VALUE;
    private int standardSize;
    private SettingToggleButton<ViewItems> viewModeToggle;
    private SettingToggleButton<SortOrder> sortByToggle;
    private SettingToggleButton<SortDir> sortDirToggle;
    private boolean isAutoFocus = false;
    private int currentMouseX = 0;
    private int currentMouseY = 0;

    public MEMonitorableScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new ItemRepo(scrollbar, this);
        this.setScrollBar();
        this.field_146999_f = 185;
        this.field_147000_g = 204;
        Object te = ((AEBaseContainer)((Object)container)).getTarget();
        if (te instanceof IViewCellStorage) {
            this.field_146999_f += 33;
        }
        this.standardSize = this.field_146999_f;
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        ((MEMonitorableContainer)this.field_147002_h).setGui(this);
        this.viewCell = te instanceof IViewCellStorage;
        if (te instanceof SecurityStationTileEntity) {
            this.myName = GuiText.Security;
        } else if (te instanceof WirelessTerminalGuiObject) {
            this.myName = GuiText.WirelessTerminal;
        } else if (te instanceof IPortableCell) {
            this.myName = GuiText.PortableCell;
        } else if (te instanceof IMEChest) {
            this.myName = GuiText.Chest;
        } else if (te instanceof AbstractTerminalPart) {
            this.myName = GuiText.Terminal;
        } else {
            throw new IllegalArgumentException("Invalid GUI target given: " + te);
        }
    }

    public void postUpdate(List<IAEItemStack> list) {
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
        this.getScrollBar().setRange(0, (this.repo.size() + this.perRow - 1) / this.perRow - this.rows, Math.max(1, this.rows / 6));
    }

    private void showCraftingStatus() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(CraftingStatusContainer.TYPE));
    }

    @Override
    public void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.maxRows = this.getMaxRows();
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.perRow = terminalStyle != TerminalStyle.FULL ? 9 : 9 + (this.field_230708_k_ - this.standardSize) / 18;
        this.field_146999_f = this.standardSize + (this.perRow - 9) * 18;
        int magicNumber = 115;
        int extraSpace = this.field_230709_l_ - 115 - this.reservedSpace;
        this.rows = extraSpace / 18;
        if (this.rows > this.maxRows) {
            this.rows = this.maxRows;
        }
        if (this.rows < 3) {
            this.rows = 3;
        }
        this.field_147000_g = 115 + this.rows * 18 + this.reservedSpace;
        this.getMeSlots().clear();
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.perRow; ++x) {
                this.getMeSlots().add(new InternalSlotME(this.repo, x + y * this.perRow, this.offsetX + x * 18, 18 + y * 18));
            }
        }
        super.func_231160_c_();
        int offset = this.field_147009_r + 8;
        if (this.customSortOrder) {
            this.sortByToggle = (SettingToggleButton)this.func_230480_a_((Widget)new SettingToggleButton<SortOrder>(this.field_147003_i - 18, offset, Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
            offset += 20;
        }
        if (this.viewCell || this instanceof WirelessTermScreen) {
            this.viewModeToggle = (SettingToggleButton)this.func_230480_a_((Widget)new SettingToggleButton<ViewItems>(this.field_147003_i - 18, offset, Settings.VIEW_MODE, this.getSortDisplay(), this::toggleServerSetting));
            offset += 20;
        }
        this.sortDirToggle = new SettingToggleButton<SortDir>(this.field_147003_i - 18, offset, Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting);
        this.func_230480_a_((Widget)this.sortDirToggle);
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        this.func_230480_a_((Widget)new SettingToggleButton<SearchBoxMode>(this.field_147003_i - 18, offset += 20, Settings.SEARCH_MODE, searchMode, Platform::isSearchModeAvailable, this::toggleTerminalSearchMode));
        offset += 20;
        if (!(this instanceof MEPortableCellScreen) || this instanceof WirelessTermScreen) {
            this.func_230480_a_((Widget)new SettingToggleButton<TerminalStyle>(this.field_147003_i - 18, offset, Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        }
        this.searchField = new AETextField(this.field_230712_o_, this.field_147003_i + Math.max(80, this.offsetX), this.field_147009_r + 4, 90, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.setSelectionColor(-16744448);
        this.searchField.func_146189_e(true);
        if (this.viewCell || this instanceof WirelessTermScreen) {
            this.craftingStatusBtn = (TabButton)this.func_230480_a_((Widget)new TabButton(this.field_147003_i + 170, this.field_147009_r - 4, 178, GuiText.CraftingStatus.text(), this.field_230707_j_, btn -> this.showCraftingStatus()));
            this.craftingStatusBtn.setHideEdge(13);
        }
        this.isAutoFocus = SearchBoxMode.AUTOSEARCH == searchMode || SearchBoxMode.JEI_AUTOSEARCH == searchMode || SearchBoxMode.AUTOSEARCH_KEEP == searchMode || SearchBoxMode.JEI_AUTOSEARCH_KEEP == searchMode;
        boolean isKeepFilter = SearchBoxMode.AUTOSEARCH_KEEP == searchMode || SearchBoxMode.JEI_AUTOSEARCH_KEEP == searchMode || SearchBoxMode.MANUAL_SEARCH_KEEP == searchMode || SearchBoxMode.JEI_MANUAL_SEARCH_KEEP == searchMode;
        boolean isJEIEnabled = SearchBoxMode.JEI_AUTOSEARCH == searchMode || SearchBoxMode.JEI_MANUAL_SEARCH == searchMode;
        this.searchField.func_146195_b(this.isAutoFocus);
        if (isJEIEnabled) {
            memoryText = JEIFacade.instance().getSearchText();
        }
        if (isKeepFilter && memoryText != null && !memoryText.isEmpty()) {
            this.searchField.func_146180_a(memoryText);
            this.searchField.selectAll();
            this.repo.setSearchString(memoryText);
            this.repo.updateView();
            this.setScrollBar();
        }
        craftingGridOffsetX = Integer.MAX_VALUE;
        craftingGridOffsetY = Integer.MAX_VALUE;
        for (Slot s : ((MEMonitorableContainer)this.field_147002_h).field_75151_b) {
            if (s instanceof AppEngSlot && s.field_75223_e < 197) {
                this.repositionSlot((AppEngSlot)s);
            }
            if (!(s instanceof CraftingMatrixSlot) && !(s instanceof FakeCraftingMatrixSlot) || s.field_75223_e <= 0 || s.field_75221_f <= 0) continue;
            craftingGridOffsetX = Math.min(craftingGridOffsetX, s.field_75223_e);
            craftingGridOffsetY = Math.min(craftingGridOffsetY, s.field_75221_f);
        }
        craftingGridOffsetX -= 25;
        craftingGridOffsetY -= 6;
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.getGuiDisplayName(this.myName.text()).getString(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.inventory.text().getString(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
    }

    @Override
    public boolean func_231044_a_(double xCoord, double yCoord, int btn) {
        if (this.searchField.func_231044_a_(xCoord, yCoord, btn)) {
            return true;
        }
        if (this.searchField.func_231047_b_(xCoord, yCoord) && btn == 1) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return super.func_231044_a_(xCoord, yCoord, btn);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_195559_v.func_197967_a(false);
        memoryText = this.searchField.func_146179_b();
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture(this.getBackground());
        int x_width = 197;
        this.func_238474_b_(matrixStack, offsetX, offsetY, 0, 0, 197, 18);
        if (this.viewCell || this instanceof SecurityStationScreen) {
            this.func_238474_b_(matrixStack, offsetX + 197, offsetY, 197, 0, 46, 128);
        }
        for (int x = 0; x < this.rows; ++x) {
            this.func_238474_b_(matrixStack, offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.func_238474_b_(matrixStack, offsetX, offsetY + 16 + this.rows * 18 + this.lowerTextureOffset, 0, 70, 197, 99 + this.reservedSpace - this.lowerTextureOffset);
        if (this.viewCell) {
            boolean update = false;
            for (int i = 0; i < 5; ++i) {
                if (this.myCurrentViewCells[i] == ((MEMonitorableContainer)this.field_147002_h).getCellViewSlot(i).func_75211_c()) continue;
                update = true;
                this.myCurrentViewCells[i] = ((MEMonitorableContainer)this.field_147002_h).getCellViewSlot(i).func_75211_c();
            }
            if (update) {
                this.repo.setViewCell(this.myCurrentViewCells);
            }
        }
        if (this.searchField != null) {
            this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    int getMaxRows() {
        return AEConfig.instance().getTerminalStyle() == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
    }

    protected void repositionSlot(AppEngSlot s) {
        s.field_75221_f = s.getY() + this.field_147000_g - 78 - 5;
    }

    public boolean func_231042_a_(char character, int p_charTyped_2_) {
        if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
            return true;
        }
        if (this.isAutoFocus && !this.searchField.func_230999_j_() && this.isHovered()) {
            this.searchField.func_146195_b(true);
        }
        if (this.searchField.func_230999_j_() && this.searchField.func_231042_a_(character, p_charTyped_2_)) {
            this.repo.setSearchString(this.searchField.func_146179_b());
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode != 256 && !this.checkHotbarKeys(input)) {
            if (AppEng.proxy.isActionKey(ActionKey.TOGGLE_FOCUS, input)) {
                this.searchField.func_146195_b(!this.searchField.func_230999_j_());
                return true;
            }
            if (!this.searchField.func_230999_j_() && this.isAutoFocus && this.isHovered()) {
                this.searchField.func_146195_b(true);
            }
            if (this.searchField.func_230999_j_()) {
                if (keyCode == 257) {
                    this.searchField.func_146195_b(false);
                    return true;
                }
                if (this.searchField.func_231046_a_(keyCode, scanCode, p_keyPressed_3_)) {
                    this.repo.setSearchString(this.searchField.func_146179_b());
                    this.repo.updateView();
                    this.setScrollBar();
                }
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    private boolean isHovered() {
        return this.func_195359_a(0, 0, this.field_146999_f, this.field_147000_g, this.currentMouseX, this.currentMouseY);
    }

    @Override
    public void func_231023_e_() {
        this.repo.setPower(((MEMonitorableContainer)this.field_147002_h).isPowered());
        super.func_231023_e_();
    }

    @Override
    public SortOrder getSortBy() {
        return (SortOrder)this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return (SortDir)this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return (ViewItems)this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.sortByToggle != null) {
            this.sortByToggle.set(this.getSortBy());
        }
        if (this.sortDirToggle != null) {
            this.sortDirToggle.set(this.getSortDir());
        }
        if (this.viewModeToggle != null) {
            this.viewModeToggle.set(this.getSortDisplay());
        }
        this.repo.updateView();
    }

    int getReservedSpace() {
        return this.reservedSpace;
    }

    void setReservedSpace(int reservedSpace) {
        this.reservedSpace = reservedSpace;
    }

    public boolean isCustomSortOrder() {
        return this.customSortOrder;
    }

    void setCustomSortOrder(boolean customSortOrder) {
        this.customSortOrder = customSortOrder;
    }

    public int getStandardSize() {
        return this.standardSize;
    }

    void setStandardSize(int standardSize) {
        this.standardSize = standardSize;
    }

    private void toggleTerminalSearchMode(SettingToggleButton<SearchBoxMode> btn, boolean backwards) {
        SearchBoxMode next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalSearchMode(next);
        btn.set(next);
        this.reinitalize();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitalize();
    }

    private <S extends Enum<S>> void toggleServerSetting(SettingToggleButton<S> btn, boolean backwards) {
        S next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting().name(), ((Enum)next).name()));
        btn.set(next);
    }

    private void reinitalize() {
        this.field_230705_e_.removeAll(this.field_230710_m_);
        this.field_230710_m_.clear();
        this.func_231160_c_();
    }

    static {
        memoryText = "";
    }
}

