/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.SkyChestContainer;
import appeng.tile.storage.SkyChestTileEntity;
import appeng.util.Platform;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SkyChestBlock
extends AEBaseTileBlock<SkyChestTileEntity> {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.0625;
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    public final SkyChestType type;

    public SkyChestBlock(SkyChestType type, AbstractBlock.Properties props) {
        super(props);
        this.type = type;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        if (Platform.isServer()) {
            SkyChestTileEntity tile = (SkyChestTileEntity)this.getTileEntity((IBlockReader)w, pos);
            if (tile == null) {
                return ActionResultType.PASS;
            }
            ContainerOpener.openContainer(SkyChestContainer.TYPE, player, ContainerLocator.forTileEntity(tile));
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SkyChestTileEntity sk = (SkyChestTileEntity)this.getTileEntity(worldIn, pos);
        Direction up = sk != null ? sk.getUp() : Direction.UP;
        return SHAPES.get(up);
    }

    private static AxisAlignedBB computeAABB(Direction up) {
        double offsetX = up.func_82601_c() == 0 ? 0.06 : 0.0;
        double offsetY = up.func_96559_d() == 0 ? 0.06 : 0.0;
        double offsetZ = up.func_82599_e() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (up.func_82601_c() < 0 ? 0.0 : (double)up.func_82601_c() * 0.0625));
        double minY = Math.max(0.0, offsetY + (up.func_96559_d() < 0 ? 0.0625 : (double)up.func_96559_d() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (up.func_82599_e() < 0 ? 0.0 : (double)up.func_82599_e() * 0.0625));
        double maxX = Math.min(1.0, 1.0 - offsetX - (up.func_82601_c() < 0 ? 0.0625 : (double)up.func_82601_c() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (up.func_96559_d() < 0 ? 0.0 : (double)up.func_96559_d() * 0.0625));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (up.func_82599_e() < 0 ? 0.0625 : (double)up.func_82599_e() * 0.0));
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    static {
        for (Direction up : Direction.values()) {
            AxisAlignedBB aabb = SkyChestBlock.computeAABB(up);
            SHAPES.put(up, VoxelShapes.func_197881_a((AxisAlignedBB)aabb));
        }
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

