/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BlockLootProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(DataGenerator generator) {
        this.generator = generator;
        for (Block b2 : Registry.field_212618_g) {
            ResourceLocation id = Registry.field_212618_g.func_177774_c((Object)b2);
            if (!"botania".equals(id.func_110624_b())) continue;
            if (b2 instanceof SlabBlock) {
                this.functionTable.put(b2, BlockLootProvider::genSlab);
                continue;
            }
            if (b2 instanceof BlockModDoubleFlower) {
                this.functionTable.put(b2, BlockLootProvider::genDoubleFlower);
                continue;
            }
            if (b2 instanceof BlockAltGrass) {
                this.functionTable.put(b2, BlockLootProvider::genAltGrass);
                continue;
            }
            if (!id.func_110623_a().matches("metamorphic_\\w+_stone")) continue;
            this.functionTable.put(b2, BlockLootProvider::genMetamorphicStone);
        }
        this.functionTable.put(ModBlocks.bifrost, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.cocoon, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.fakeAir, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.manaFlame, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.pistonRelay, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.cacophonium, b -> BlockLootProvider.genRegular(Blocks.field_196586_al));
        this.functionTable.put(ModBlocks.enchantedSoil, b -> BlockLootProvider.genRegular(Blocks.field_150346_d));
        this.functionTable.put(ModBlocks.enchanter, b -> BlockLootProvider.genRegular(Blocks.field_150368_y));
        this.functionTable.put(ModBlocks.mossyAltar, b -> BlockLootProvider.genRegular(ModBlocks.defaultAltar));
        this.functionTable.put(ModBlocks.cellBlock, BlockLootProvider::genCellBlock);
        this.functionTable.put(ModBlocks.root, BlockLootProvider::genRoot);
        this.functionTable.put(ModBlocks.solidVines, BlockLootProvider::genSolidVine);
        this.functionTable.put(ModBlocks.tinyPotato, BlockLootProvider::genTinyPotato);
        this.functionTable.put(ModSubtiles.gourmaryllis, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(ModSubtiles.gourmaryllisFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(ModSubtiles.hydroangeas, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(ModSubtiles.hydroangeasFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(ModSubtiles.munchdew, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ModSubtiles.munchdewFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ModSubtiles.rafflowsia, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(ModSubtiles.rafflowsiaFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(ModSubtiles.spectrolus, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(ModSubtiles.spectrolusFloating, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(ModSubtiles.thermalily, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ModSubtiles.thermalilyFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block b : Registry.field_212618_g) {
            ResourceLocation id = Registry.field_212618_g.func_177774_c((Object)b);
            if (!"botania".equals(id.func_110624_b())) continue;
            Function<Block, LootTable.Builder> func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular);
            tables.put(id, func.apply(b));
        }
        for (Map.Entry e : tables.entrySet()) {
            Path path = BlockLootProvider.getPath(this.generator.func_200391_b(), (ResourceLocation)e.getKey());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)((LootTable.Builder)e.getValue()).func_216039_a(LootParameterSets.field_216267_h).func_216038_b()), (Path)path);
        }
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    private static LootTable.Builder empty(Block b) {
        return LootTable.func_216119_b();
    }

    private static LootTable.Builder genCopyNbt(Block b, String ... tags) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        CopyNbt.Builder func = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY);
        for (String tag : tags) {
            func = func.func_216056_a(tag, "BlockEntityTag." + tag);
        }
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212841_b_((ILootFunction.IBuilder)func);
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genCellBlock(Block b) {
        ItemPredicate.Builder silkPred = ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)));
        LootEntry.Builder silk = ItemLootEntry.func_216168_a((IItemProvider)b).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)silkPred));
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(silk));
    }

    private static LootTable.Builder genTinyPotato(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY));
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genMetamorphicStone(Block b) {
        String cobbleName = Registry.field_212618_g.func_177774_c((Object)b).func_110623_a().replaceAll("_stone", "_cobblestone");
        Block cobble = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(cobbleName)).get();
        return BlockLootProvider.genRegular(cobble);
    }

    private static LootTable.Builder genSolidVine(Block b) {
        StandaloneLootEntry.Builder entry = TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("blocks/vine"));
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
    }

    private static LootTable.Builder genRoot(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)ModItems.livingroot).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
    }

    private static LootTable.Builder genSlab(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
    }

    private static LootTable.Builder genDoubleFlower(Block b) {
        LootEntry.Builder entry = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)b).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER)))).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.SHEARS)));
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genAltGrass(Block b) {
        ItemPredicate.Builder silkPred = ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)));
        LootEntry.Builder silk = ItemLootEntry.func_216168_a((IItemProvider)b).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)silkPred));
        LootEntry.Builder dirt = ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150346_d).func_212840_b_(SurvivesExplosion.func_215968_b());
        AlternativesLootEntry.Builder entry = AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{silk, dirt});
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry);
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genRegular(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    @Nonnull
    public String func_200397_b() {
        return "Botania block loot tables";
    }
}

