/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.world.MysticalFlowerConfig;
import vazkii.botania.common.world.MysticalFlowerFeature;
import vazkii.botania.common.world.MysticalMushroomConfig;
import vazkii.botania.common.world.MysticalMushroomFeature;
import vazkii.botania.mixin.AccessorBiomeGenerationSettings;

public class ModFeatures {
    public static final Feature<MysticalFlowerConfig> MYSTICAL_FLOWERS = new MysticalFlowerFeature();
    public static final Feature<MysticalMushroomConfig> MYSTICAL_MUSHROOMS = new MysticalMushroomFeature();
    public static final RegistryKey<ConfiguredFeature<?, ?>> MYSTICAL_FLOWERS_CONF = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243552_au, (ResourceLocation)ResourceLocationHelper.prefix("mystical_flowers"));
    public static final RegistryKey<ConfiguredFeature<?, ?>> MYSTICAL_MUSHROOMS_CONF = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243552_au, (ResourceLocation)ResourceLocationHelper.prefix("mystical_mushrooms"));
    public static final Set<Biome.Category> TYPE_BLACKLIST = ImmutableSet.of((Object)Biome.Category.NETHER, (Object)Biome.Category.THEEND, (Object)Biome.Category.ICY, (Object)Biome.Category.MUSHROOM);

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ModBlocks.register(r, "mystical_flowers", MYSTICAL_FLOWERS);
        ModBlocks.register(r, "mystical_mushrooms", MYSTICAL_MUSHROOMS);
    }

    public static void addWorldgen(MinecraftServer server) {
        Botania.LOGGER.debug("Injecting flowers and mushrooms into dynamic biomes...");
        MutableRegistry featReg = server.func_244267_aX().func_243612_b(Registry.field_243552_au);
        ConfiguredFeature flowers = (ConfiguredFeature)featReg.func_230516_a_(MYSTICAL_FLOWERS_CONF);
        ConfiguredFeature mushrooms = (ConfiguredFeature)featReg.func_230516_a_(MYSTICAL_MUSHROOMS_CONF);
        if (flowers == null || mushrooms == null) {
            Botania.LOGGER.error("Flower or mushroom configured_feature JSONs are missing! Skipping worldgen.");
            return;
        }
        for (Biome biome : server.func_244267_aX().func_243612_b(Registry.field_239720_u_)) {
            if (!TYPE_BLACKLIST.contains(biome.func_201856_r())) {
                ModFeatures.injectIntoBiome(biome, flowers);
            }
            if (biome.func_201856_r() == Biome.Category.THEEND) continue;
            ModFeatures.injectIntoBiome(biome, mushrooms);
        }
    }

    public static void injectIntoBiome(Biome biome, ConfiguredFeature<?, ?> feature) {
        ArrayList features = biome.func_242440_e().func_242498_c();
        if (features instanceof ImmutableList) {
            ArrayList list = new ArrayList();
            for (List list2 : features) {
                list.add(new ArrayList(list2));
            }
            ((AccessorBiomeGenerationSettings)biome.func_242440_e()).setFeatures(list);
            features = list;
        }
        GenerationStage.Decoration stage = GenerationStage.Decoration.VEGETAL_DECORATION;
        while (features.size() <= stage.ordinal()) {
            features.add(new ArrayList());
        }
        ((List)features.get(stage.ordinal())).add(() -> feature);
    }
}

