/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorLivingEntity;

public class ItemInfiniteFruit
extends ItemRelic
implements IManaUsingItem {
    public ItemInfiniteFruit(Item.Properties props) {
        super(props);
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return ItemInfiniteFruit.isBoot(stack) ? UseAction.DRINK : UseAction.EAT;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_71043_e(false) && this.isRightPlayer(player, stack)) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void func_219972_a(@Nonnull World world, @Nonnull LivingEntity living, @Nonnull ItemStack stack, int count) {
        if (!(living instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)living;
        if (ManaItemHandler.instance().requestManaExact(stack, player, 500, true)) {
            if (count % 5 == 0) {
                player.func_71024_bL().func_75122_a(1, 1.0f);
            }
            if (count == 5 && player.func_71043_e(false)) {
                ((AccessorLivingEntity)player).setActiveItemStackUseCount(20);
            }
        }
    }

    public static boolean isBoot(ItemStack stack) {
        String name = stack.func_200301_q().getString().toLowerCase(Locale.ROOT).trim();
        return name.equals("das boot");
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return ResourceLocationHelper.prefix("challenge/infinite_fruit");
    }
}

