/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelAxe;

public class ItemTerraAxe
extends ItemManasteelAxe
implements ISequentialBreaker {
    private static final int BLOCK_SWAP_RATE = 10;
    public static final int BLOCK_RANGE = 32;
    private static final int LEAF_BLOCK_RANGE = 3;
    private static final int MANA_PER_DAMAGE = 100;
    private static final Map<RegistryKey<World>, Set<BlockSwapper>> blockSwappers = new HashMap<RegistryKey<World>, Set<BlockSwapper>>();

    public ItemTerraAxe(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
        MinecraftForge.EVENT_BUS.addListener(this::onTickEnd);
    }

    public static boolean shouldBreak(PlayerEntity player) {
        return !player.func_225608_bj_() && !ItemTemperanceStone.hasTemperanceActive(player);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult raycast = ToolCommons.raytraceFromEntity((Entity)player, 10.0, false);
        if (raycast.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction face = raycast.func_216354_b();
            this.breakOtherBlock(player, stack, pos, pos, face);
            BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(PlayerEntity player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (ItemTerraAxe.shouldBreak(player)) {
            ItemTerraAxe.addBlockSwapper(player.field_70170_p, player, stack, pos, 32, true);
        }
    }

    @Override
    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return false;
    }

    private void onTickEnd(TickEvent.WorldTickEvent event) {
        RegistryKey dim;
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.func_234923_W_())) {
            Set<BlockSwapper> swappers = blockSwappers.get(dim);
            swappers.removeIf(next -> next == null || !next.tick());
        }
    }

    private static void addBlockSwapper(World world, PlayerEntity player, ItemStack stack, BlockPos origCoords, int steps, boolean leaves) {
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, steps, leaves);
        if (world.field_72995_K) {
            return;
        }
        RegistryKey dim = world.func_234923_W_();
        blockSwappers.computeIfAbsent((RegistryKey<World>)dim, d -> new HashSet()).add(swapper);
    }

    private static class BlockSwapper {
        public static final int SINGLE_BLOCK_RADIUS = 1;
        private final World world;
        private final PlayerEntity player;
        private final ItemStack truncator;
        private final BlockPos origin;
        private final boolean treatLeavesSpecial;
        private final int range;
        private final PriorityQueue<SwapCandidate> candidateQueue;
        private final Set<BlockPos> completedCoords;

        public BlockSwapper(World world, PlayerEntity player, ItemStack truncator, BlockPos origCoords, int range, boolean leaves) {
            this.world = world;
            this.player = player;
            this.truncator = truncator;
            this.origin = origCoords;
            this.range = range;
            this.treatLeavesSpecial = leaves;
            this.candidateQueue = new PriorityQueue();
            this.completedCoords = new HashSet<BlockPos>();
            this.candidateQueue.offer(new SwapCandidate(this.origin, this.range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate cand = this.candidateQueue.poll();
                if (this.completedCoords.contains(cand.coordinates) || cand.range <= 0) continue;
                ToolCommons.removeBlockWithDrops(this.player, this.truncator, this.world, cand.coordinates, state -> ToolCommons.materialsAxe.contains(state.func_185904_a()), false, this.treatLeavesSpecial);
                --remainingSwaps;
                this.completedCoords.add(cand.coordinates);
                for (BlockPos adj : this.adjacent(cand.coordinates)) {
                    Block block = this.world.func_180495_p(adj).func_177230_c();
                    boolean isWood = BlockTags.field_200031_h.func_230235_a_((Object)block);
                    boolean isLeaf = BlockTags.field_206952_E.func_230235_a_((Object)block);
                    if (!isWood && !isLeaf) continue;
                    int newRange = this.treatLeavesSpecial && isLeaf ? Math.min(3, cand.range - 1) : cand.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<BlockPos> adjacent(BlockPos original) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.func_177982_a(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public static final class SwapCandidate
        implements Comparable<SwapCandidate> {
            public final BlockPos coordinates;
            public final int range;

            public SwapCandidate(BlockPos coordinates, int range) {
                this.coordinates = coordinates;
                this.range = range;
            }

            @Override
            public int compareTo(@Nonnull SwapCandidate other) {
                return other.range - this.range;
            }

            public boolean equals(Object other) {
                if (!(other instanceof SwapCandidate)) {
                    return false;
                }
                SwapCandidate cand = (SwapCandidate)other;
                return this.coordinates.equals((Object)cand.coordinates) && this.range == cand.range;
            }

            public int hashCode() {
                return Objects.hash(this.coordinates, this.range);
            }
        }
    }
}

