/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;

public class CorporeaStringMatcher
implements ICorporeaRequestMatcher {
    private static final Pattern patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    public static final String[] WILDCARD_STRINGS = new String[]{"...", "~", "+", "?"};
    private static final String TAG_REQUEST_CONTENTS = "requestContents";
    private final String[] expression;

    public CorporeaStringMatcher(String expression) {
        boolean contains = false;
        for (String wc : WILDCARD_STRINGS) {
            if (expression.endsWith(wc)) {
                contains = true;
                expression = expression.substring(0, expression.length() - wc.length());
            } else if (expression.startsWith(wc)) {
                contains = true;
                expression = expression.substring(wc.length());
            }
            if (contains) break;
        }
        this.expression = (contains ? "*" + expression + "*" : expression).split("\\*+", -1);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        String name = CorporeaStringMatcher.stripControlCodes(stack.func_200301_q().getString().toLowerCase().trim());
        return this.matchGlob(name) || this.matchGlob(name + "s") || this.matchGlob(name + "es") || name.endsWith("y") && this.matchGlob(name.substring(0, name.length() - 1) + "ies");
    }

    public static CorporeaStringMatcher createFromNBT(CompoundNBT tag) {
        String expression = tag.func_74779_i(TAG_REQUEST_CONTENTS);
        return new CorporeaStringMatcher(expression);
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        tag.func_74778_a(TAG_REQUEST_CONTENTS, this.toString());
    }

    @Override
    public ITextComponent getRequestName() {
        String value = WordUtils.capitalizeFully((String)this.toString());
        if (value.charAt(0) == '*' && value.length() > 1) {
            value = "*" + Character.toUpperCase(value.charAt(1)) + value.substring(2);
        }
        return new StringTextComponent(value);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("*");
        for (String s : this.expression) {
            sj.add(s);
        }
        return sj.toString();
    }

    private boolean matchGlob(String str) {
        if (this.expression.length == 1) {
            return this.expression[0].equals(str);
        }
        if (!str.startsWith(this.expression[0])) {
            return false;
        }
        int offset = this.expression[0].length();
        for (int i = 1; i < this.expression.length - 1; ++i) {
            String section = this.expression[i];
            int found = str.indexOf(section, offset);
            if (found == -1) {
                return false;
            }
            offset = found + section.length();
        }
        return str.substring(offset).endsWith(this.expression[this.expression.length - 1]);
    }

    private static String stripControlCodes(String str) {
        return patternControlCode.matcher(str).replaceAll("");
    }
}

